/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.skinsrestorer;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.skinsrestorer.SkinsRestorerIntegration;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.PlatformType;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;

@Singleton
public class SkinsRestorerModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final SkinsRestorerIntegration skinsRestorerIntegration;
    private final PlatformServerAdapter platformServerAdapter;

    @Override
    public void onEnable() {
        super.onEnable();
        if (this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC) {
            this.skinsRestorerIntegration.hookLater();
        } else {
            this.skinsRestorerIntegration.hook();
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.skinsRestorerIntegration.unhook();
    }

    @Override
    public Integration.Skinsrestorer config() {
        return this.fileResolver.getIntegration().getSkinsrestorer();
    }

    @Override
    public Permission.Integration.Skinsrestorer permission() {
        return this.fileResolver.getPermission().getIntegration().getSkinsrestorer();
    }

    public String getTextureUrl(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.skinsRestorerIntegration.getTextureUrl(fPlayer);
    }

    public PlayerHeadObjectContents.ProfileProperty getProfileProperty(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.skinsRestorerIntegration.getProfileProperty(fPlayer);
    }

    @Inject
    @Generated
    public SkinsRestorerModule(FileResolver fileResolver, SkinsRestorerIntegration skinsRestorerIntegration, PlatformServerAdapter platformServerAdapter) {
        this.fileResolver = fileResolver;
        this.skinsRestorerIntegration = skinsRestorerIntegration;
        this.platformServerAdapter = platformServerAdapter;
    }
}

