/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.supervanish;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.supervanish.VanishIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class VanishModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final VanishIntegration vanishIntegration;

    @Override
    public void onEnable() {
        super.onEnable();
        this.vanishIntegration.hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.vanishIntegration.unhook();
    }

    @Override
    public Integration.Supervanish config() {
        return this.fileResolver.getIntegration().getSupervanish();
    }

    @Override
    public Permission.Integration.Supervanish permission() {
        return this.fileResolver.getPermission().getIntegration().getSupervanish();
    }

    public boolean isVanished(FEntity sender) {
        if (this.isModuleDisabledFor(sender)) {
            return false;
        }
        return this.vanishIntegration.isVanished(sender);
    }

    @Inject
    @Generated
    public VanishModule(FileResolver fileResolver, VanishIntegration vanishIntegration) {
        this.fileResolver = fileResolver;
        this.vanishIntegration = vanishIntegration;
    }
}

