/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.twitch;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.TwitchClient;
import com.github.twitch4j.TwitchClientBuilder;
import com.github.twitch4j.events.ChannelGoLiveEvent;
import feign.Logger;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.twitch.listener.ChannelMessageListener;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class TwitchIntegration
implements FIntegration {
    private final FileResolver fileResolver;
    private final ChannelMessageListener channelMessageListener;
    private final PlatformServerAdapter platformServerAdapter;
    private final SystemVariableResolver systemVariableResolver;
    private final FLogger fLogger;
    private TwitchClient twitchClient;

    @Override
    public void hook() {
        Integration.Twitch integration = this.fileResolver.getIntegration().getTwitch();
        String token = this.systemVariableResolver.substituteEnvVars(integration.getToken());
        String identityProvider = this.systemVariableResolver.substituteEnvVars(integration.getClientID());
        if (token.isEmpty() || identityProvider.isEmpty()) {
            return;
        }
        OAuth2Credential oAuth2Credential = new OAuth2Credential(identityProvider, token);
        this.twitchClient = TwitchClientBuilder.builder().withEnableChat(Boolean.valueOf(true)).withEnableEventSocket(Boolean.valueOf(true)).withEnableHelix(Boolean.valueOf(true)).withFeignLogLevel(Logger.Level.NONE).withDefaultAuthToken(oAuth2Credential).withChatAccount(oAuth2Credential).build();
        for (List<String> channels : integration.getMessageChannel().values()) {
            for (String channel : channels) {
                if (this.twitchClient.getChat().isChannelJoined(channel)) continue;
                this.twitchClient.getChat().joinChannel(channel);
            }
        }
        for (String channel : integration.getFollowChannel().keySet()) {
            this.twitchClient.getClientHelper().enableStreamEventListener(channel);
        }
        this.twitchClient.getEventManager().onEvent(ChannelGoLiveEvent.class, event -> {
            String channelName = event.getChannel().getName();
            List<String> commands = integration.getFollowChannel().get(channelName);
            if (commands == null) {
                return;
            }
            commands.forEach(this.platformServerAdapter::dispatchCommand);
        });
        if (!integration.getMessageChannel().isEmpty()) {
            this.twitchClient.getEventManager().onEvent(this.channelMessageListener.getEventType(), this.channelMessageListener::execute);
        }
        this.fLogger.info("\u2714 Twitch integration enabled");
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> twitchString) {
        List<String> channels = this.fileResolver.getIntegration().getTwitch().getMessageChannel().get(messageName);
        if (channels == null) {
            return;
        }
        if (channels.isEmpty()) {
            return;
        }
        String message = this.fileResolver.getLocalization().getIntegration().getTwitch().getMessageChannel().getOrDefault(messageName, "<final_message>");
        if (message.isEmpty()) {
            return;
        }
        message = (String)twitchString.apply(message);
        for (String channel : channels) {
            this.twitchClient.getChat().sendMessage(channel, message);
        }
    }

    @Override
    public void unhook() {
        if (this.twitchClient == null) {
            return;
        }
        this.twitchClient.close();
        this.fLogger.info("\u2716 Twitch integration disabled");
    }

    @Inject
    @Generated
    public TwitchIntegration(FileResolver fileResolver, ChannelMessageListener channelMessageListener, PlatformServerAdapter platformServerAdapter, SystemVariableResolver systemVariableResolver, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.channelMessageListener = channelMessageListener;
        this.platformServerAdapter = platformServerAdapter;
        this.systemVariableResolver = systemVariableResolver;
        this.fLogger = fLogger;
    }
}

