/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.bubble.listener;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientChatMessage;
import java.util.Collections;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.bubble.BubbleModule;
import net.flectone.pulse.module.message.chat.ChatModule;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class BubblePacketListener
implements PacketListener {
    private final FPlayerService fPlayerService;
    private final BubbleModule bubbleModule;
    private final ChatModule chatModule;

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.CHAT_MESSAGE) {
            return;
        }
        if (this.chatModule.isEnable() || !this.bubbleModule.isEnable()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getUser().getUUID());
        WrapperPlayClientChatMessage wrapper = new WrapperPlayClientChatMessage(event);
        String message = wrapper.getMessage();
        this.bubbleModule.add(fPlayer, message, Collections.emptyList());
    }

    @Inject
    @Generated
    public BubblePacketListener(FPlayerService fPlayerService, BubbleModule bubbleModule, ChatModule chatModule) {
        this.fPlayerService = fPlayerService;
        this.bubbleModule = bubbleModule;
        this.chatModule = chatModule;
    }
}

