/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.chat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.command.spy.SpyModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.bubble.BubbleModule;
import net.flectone.pulse.module.message.chat.listener.ChatPacketListener;
import net.flectone.pulse.module.message.chat.model.ChatMetadata;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.platform.sender.CooldownSender;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.MuteSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.PlatformType;
import net.flectone.pulse.util.constant.SettingText;
import org.incendo.cloud.type.tuple.Pair;

@Singleton
public class ChatModule
extends AbstractModuleLocalization<Localization.Message.Chat> {
    private final Map<String, Cooldown> cooldownMap = new HashMap<String, Cooldown>();
    private final Map<String, Sound> soundMap = new HashMap<String, Sound>();
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformServerAdapter platformServerAdapter;
    private final PermissionChecker permissionChecker;
    private final IntegrationModule integrationModule;
    private final Provider<BubbleModule> bubbleModuleProvider;
    private final Provider<SpyModule> spyModuleProvider;
    private final ListenerRegistry listenerRegistry;
    private final MuteSender muteSender;
    private final DisableSender disableSender;
    private final CooldownSender cooldownSender;
    private final ProxyRegistry proxyRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.config().getTypes().forEach((key, value) -> {
            Permission.Message.Chat.Type permissions = this.permission().getTypes().get(key);
            if (permissions == null) {
                return;
            }
            this.registerPermission(permissions);
            this.cooldownMap.put((String)key, this.createCooldown(value.getCooldown(), permissions.getCooldownBypass()));
            this.soundMap.put((String)key, this.createSound(value.getSound(), permissions.getSound()));
        });
        if (this.config().getMode() == Message.Chat.Mode.PACKET || this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC) {
            this.listenerRegistry.register(ChatPacketListener.class);
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.cooldownMap.clear();
        this.soundMap.clear();
    }

    @Override
    public MessageType messageType() {
        return MessageType.CHAT;
    }

    @Override
    public Message.Chat config() {
        return this.fileResolver.getMessage().getChat();
    }

    @Override
    public Permission.Message.Chat permission() {
        return this.fileResolver.getPermission().getMessage().getChat();
    }

    @Override
    public Localization.Message.Chat localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getChat();
    }

    public void handleChatEvent(FPlayer fPlayer, String eventMessage, Runnable cancelEvent, BiConsumer<String, Boolean> successEvent) {
        Range chatRange;
        if (this.muteSender.sendIfMuted(fPlayer)) {
            cancelEvent.run();
            return;
        }
        if (this.disableSender.sendIfDisabled(fPlayer, fPlayer, this.messageType())) {
            cancelEvent.run();
            return;
        }
        Pair<String, Message.Chat.Type> playerChat = this.getPlayerChat(fPlayer, eventMessage);
        Message.Chat.Type chatType = (Message.Chat.Type)playerChat.second();
        if (chatType == null || !chatType.isEnable()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Message.Chat::getNullChat)).build());
            cancelEvent.run();
            return;
        }
        if (this.cooldownSender.sendIfCooldown(fPlayer, this.cooldownMap.get(playerChat.first()))) {
            cancelEvent.run();
            return;
        }
        String trigger = chatType.getTrigger();
        if (!StringUtils.isEmpty((CharSequence)trigger) && eventMessage.startsWith(trigger)) {
            eventMessage = eventMessage.substring(trigger.length()).trim();
        }
        String finalMessage = (chatRange = chatType.getRange()).is(Range.Type.PROXY) || chatRange.is(Range.Type.SERVER) || chatRange.is(Range.Type.WORLD_NAME) || chatRange.is(Range.Type.WORLD_TYPE) ? this.integrationModule.checkMention(fPlayer, eventMessage) : eventMessage;
        successEvent.accept(finalMessage, ((Message.Chat.Type)playerChat.second()).isCancel());
        this.sendMessage(fPlayer, eventMessage, finalMessage, playerChat);
    }

    @Async
    public void sendMessage(FPlayer fPlayer, String eventMessage, String finalMessage, Pair<String, Message.Chat.Type> playerChat) {
        String chatName = (String)playerChat.first();
        EventMetadata chatMetadata = ((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)ChatMetadata.builder().sender(fPlayer)).format(localization -> localization.getTypes().get(chatName))).chatName(chatName)).chatType((Message.Chat.Type)playerChat.second())).destination(((Message.Chat.Type)playerChat.second()).getDestination())).range(((Message.Chat.Type)playerChat.second()).getRange())).message(finalMessage)).sound(this.soundMap.get(chatName))).filter(this.permissionFilter(chatName))).proxy(dataOutputStream -> {
            dataOutputStream.writeString(chatName);
            dataOutputStream.writeString(finalMessage);
        })).integration()).build();
        List<FPlayer> receivers = this.createReceivers(this.messageType(), chatMetadata);
        this.sendMessage(receivers, chatMetadata);
        this.checkReceiversLater(fPlayer, receivers, playerChat);
        ((SpyModule)this.spyModuleProvider.get()).checkChat(fPlayer, chatName, finalMessage);
        ((BubbleModule)this.bubbleModuleProvider.get()).add(fPlayer, eventMessage, receivers);
    }

    @Async(delay=1L)
    public void checkReceiversLater(FPlayer fPlayer, List<FPlayer> localReceivers, Pair<String, Message.Chat.Type> playerChat) {
        if (!((Message.Chat.Type)playerChat.second()).getNullReceiver().isEnable()) {
            return;
        }
        if (!this.noLocalReceiversFor(fPlayer, localReceivers)) {
            return;
        }
        if (((Message.Chat.Type)playerChat.second()).getRange().is(Range.Type.BLOCKS) || this.noGlobalReceiversFor(fPlayer, (String)playerChat.first())) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Message.Chat::getNullReceiver)).destination(((Message.Chat.Type)playerChat.second()).getNullReceiver().getDestination())).build());
        }
    }

    public Predicate<FPlayer> permissionFilter(String chatName) {
        return fReceiver -> this.permissionChecker.check((FEntity)fReceiver, this.permission().getTypes().get(chatName));
    }

    private boolean noLocalReceiversFor(FPlayer fPlayer, List<FPlayer> receivers) {
        return receivers.stream().filter(fReceiver -> !fReceiver.isUnknown()).filter(fReceiver -> !fReceiver.equals(fPlayer)).noneMatch(fReceiver -> this.integrationModule.canSeeVanished((FEntity)fReceiver, fPlayer));
    }

    private boolean noGlobalReceiversFor(FPlayer fPlayer, String chatName) {
        List<FPlayer> serverReceivers = this.fPlayerService.getOnlineFPlayers().stream().filter(this.filterReceivers(fPlayer, chatName)).toList();
        for (FPlayer fReceiver2 : serverReceivers) {
            if (fReceiver2.isIgnored(fPlayer) || !fReceiver2.isSetting(MessageType.CHAT)) continue;
            return false;
        }
        if (this.proxyRegistry.hasEnabledProxy()) {
            List<FPlayer> proxyReceivers = this.fPlayerService.findOnlineFPlayers().stream().filter(fReceiver -> !serverReceivers.contains(fReceiver)).filter(this.filterReceivers(fPlayer, chatName)).toList();
            for (FPlayer fReceiver3 : proxyReceivers) {
                this.fPlayerService.loadIgnores(fReceiver3);
                this.fPlayerService.loadSettings(fReceiver3);
                if (fReceiver3.isIgnored(fPlayer) || !fReceiver3.isSetting(MessageType.CHAT)) continue;
                return false;
            }
        }
        return true;
    }

    private Predicate<FPlayer> filterReceivers(FPlayer fPlayer, String chatName) {
        return fReceiver -> {
            if (fReceiver.isUnknown()) {
                return false;
            }
            if (fReceiver.equals(fPlayer)) {
                return false;
            }
            if (!this.integrationModule.canSeeVanished((FEntity)fReceiver, fPlayer)) {
                return false;
            }
            return this.permissionFilter(chatName).test((FPlayer)fReceiver);
        };
    }

    private Pair<String, Message.Chat.Type> getPlayerChat(FPlayer fPlayer, String eventMessage) {
        String returnedChatName = fPlayer.getSetting(SettingText.CHAT_NAME);
        Message.Chat.Type playerChat = this.config().getTypes().get(returnedChatName);
        if (playerChat != null && !StringUtils.isEmpty((CharSequence)playerChat.getTrigger())) {
            return Pair.of((Object)returnedChatName, (Object)playerChat);
        }
        int priority = Integer.MIN_VALUE;
        for (Map.Entry<String, Message.Chat.Type> entry : this.config().getTypes().entrySet()) {
            Message.Chat.Type chat = entry.getValue();
            String chatName = entry.getKey();
            if (!chat.isEnable() || chat.getTrigger() != null && !chat.getTrigger().isEmpty() && !eventMessage.startsWith(chat.getTrigger()) || eventMessage.equals(chat.getTrigger()) || chat.getPriority() <= priority || !this.permissionChecker.check((FEntity)fPlayer, this.permission().getTypes().get(chatName))) continue;
            playerChat = chat;
            priority = chat.getPriority();
            returnedChatName = chatName;
        }
        return Pair.of((Object)returnedChatName, (Object)playerChat);
    }

    @Inject
    @Generated
    public ChatModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformServerAdapter platformServerAdapter, PermissionChecker permissionChecker, IntegrationModule integrationModule, Provider<BubbleModule> bubbleModuleProvider, Provider<SpyModule> spyModuleProvider, ListenerRegistry listenerRegistry, MuteSender muteSender, DisableSender disableSender, CooldownSender cooldownSender, ProxyRegistry proxyRegistry) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformServerAdapter = platformServerAdapter;
        this.permissionChecker = permissionChecker;
        this.integrationModule = integrationModule;
        this.bubbleModuleProvider = bubbleModuleProvider;
        this.spyModuleProvider = spyModuleProvider;
        this.listenerRegistry = listenerRegistry;
        this.muteSender = muteSender;
        this.disableSender = disableSender;
        this.cooldownSender = cooldownSender;
        this.proxyRegistry = proxyRegistry;
    }
}

