/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.convertor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import lombok.Generated;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.Nullable;

@Singleton
public class LegacyColorConvertor {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("[\\da-fA-F]{6}");
    private static final Set<Option> DEFAULT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(Option.COLOR, new Option[]{Option.HEX_COLOR_STANDALONE, Option.COLOR_DOUBLE_HASH, Option.FORMAT, Option.GRADIENT, Option.FAST_RESET, Option.RESET, Option.DOUBLE_TO_ESCAPE}));
    @Named(value="legacyColorMessage")
    private final Cache<String, String> messageCache;
    private final FileResolver fileResolver;
    private final PermissionChecker permissionChecker;
    private final FLogger fLogger;

    public void convert(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE) && !this.permissionChecker.check(sender, this.fileResolver.getPermission().getMessage().getFormat().getLegacyColors())) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        messageContext.setMessage(this.convert(contextMessage));
    }

    public String convert(String text) {
        String convertedMessage;
        try {
            convertedMessage = (String)this.messageCache.get((Object)text, () -> this.convert(text, DEFAULT_OPTIONS));
        }
        catch (ExecutionException e) {
            this.fLogger.warning(e);
            convertedMessage = this.convert(text, DEFAULT_OPTIONS);
        }
        return convertedMessage;
    }

    private String convert(String text, Collection<Option> options) {
        text = StringUtils.replaceEach((String)text, (String[])new String[]{"&&", "\u00a7"}, (String[])new String[]{"&", "&"});
        if (options.contains((Object)Option.COLOR_DOUBLE_HASH)) {
            text = this.replaceDoubleHashHexColor(text);
        }
        if (options.contains((Object)Option.HEX_COLOR_STANDALONE)) {
            text = this.replaceHexColorStandalone(text);
        }
        String colorTagStart = options.contains((Object)Option.VERBOSE_HEX_COLOR) ? "color:#" : "#";
        ArrayList<String> order = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean defCloseValue = options.contains((Object)Option.CLOSE_COLORS);
        boolean fastReset = options.contains((Object)Option.FAST_RESET);
        boolean closeLastTag = defCloseValue;
        int index = 0;
        int nextIndex = text.indexOf(38);
        int length = text.length();
        while (index < length) {
            if (nextIndex == -1) {
                builder.append(text, index, length);
                break;
            }
            builder.append(text, index, nextIndex);
            index = nextIndex + 1;
            if (index >= length) {
                builder.append('&');
                break;
            }
            char symbol = text.charAt(index);
            String tag = this.tagByChar(symbol, options);
            if (tag == null) {
                builder.append('&').append(symbol);
            } else {
                switch (tag) {
                    case "hex_color": {
                        String color;
                        if (symbol == '#') {
                            if (length > index + 6 && this.isHexPattern(text, index + 1)) {
                                this.handleClosing(order, builder, closeLastTag, fastReset);
                                closeLastTag = defCloseValue;
                                String builtTag = colorTagStart + text.substring(index + 1, index + 7);
                                builder.append('<').append(builtTag).append('>');
                                index += 6;
                                order.add(builtTag);
                                break;
                            }
                        } else if (length > index + 12 && (color = this.extractLegacyHex(text, index + 1)) != null) {
                            this.handleClosing(order, builder, closeLastTag, fastReset);
                            closeLastTag = defCloseValue;
                            String builtTag = colorTagStart + color;
                            builder.append('<').append(builtTag).append('>');
                            index += 12;
                            order.add(builtTag);
                            break;
                        }
                        builder.append('&').append(symbol);
                        break;
                    }
                    case "gradient": {
                        String[] split;
                        int endIndex = -1;
                        for (int inner = index + 1; inner < length; ++inner) {
                            char inCh = Character.toLowerCase(text.charAt(inner));
                            if (inCh == '@') {
                                endIndex = inner;
                                break;
                            }
                            if (!('a' <= inCh && inCh <= 'z' || '0' <= inCh && inCh <= '9' || inCh == '#' || inCh == '-')) break;
                        }
                        if (endIndex == -1 || (split = text.substring(index + 1, endIndex).split("-")).length == 1) {
                            builder.append("&@");
                            break;
                        }
                        ArrayList<String> colors = new ArrayList<String>(split.length);
                        for (String color : split) {
                            if (color.length() == 1 ? (color = this.colorByChar(color.charAt(0))) == null : color.startsWith("#") && (color.length() < 7 || !this.isHexPattern(color, 1)) || NamedTextColor.NAMES.value((Object)color) == null) break;
                            colors.add(color);
                        }
                        if (colors.size() != split.length) break;
                        index = endIndex;
                        this.handleClosing(order, builder, closeLastTag, fastReset);
                        closeLastTag = true;
                        builder.append("<gradient:").append(String.join((CharSequence)":", colors)).append('>');
                        order.add(tag);
                        break;
                    }
                    case "reset": {
                        order.clear();
                        builder.append("<reset>");
                        break;
                    }
                    case "b": 
                    case "u": 
                    case "st": 
                    case "i": 
                    case "obf": {
                        order.add(tag);
                        builder.append('<').append(tag).append('>');
                        break;
                    }
                    default: {
                        this.handleClosing(order, builder, closeLastTag, fastReset);
                        closeLastTag = defCloseValue;
                        order.add(tag);
                        builder.append('<').append(tag).append('>');
                    }
                }
            }
            nextIndex = text.indexOf(38, ++index);
        }
        if (closeLastTag || !fastReset) {
            this.handleClosing(order, builder, closeLastTag, closeLastTag && fastReset);
        }
        return builder.toString();
    }

    @Nullable
    private String extractLegacyHex(String input, int from) {
        StringBuilder builder = new StringBuilder(6);
        int end = from + 12;
        for (int i = from + 1; i <= end; i += 2) {
            char ch = input.charAt(i);
            if (!this.isHexDigit(ch)) {
                return null;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private String replaceHexColorStandalone(String text) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < text.length()) {
            int nextIndex = text.indexOf(35, index);
            if (nextIndex == -1) {
                result.append(text, index, text.length());
                break;
            }
            if (this.isHexColorStandalone(text, nextIndex)) {
                result.append(text, index, nextIndex).append("<color:").append(text, nextIndex, nextIndex + 7).append('>');
                index = nextIndex + 7;
                continue;
            }
            result.append(text, index, nextIndex + 1);
            index = nextIndex + 1;
        }
        return result.toString();
    }

    private String replaceDoubleHashHexColor(String text) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < text.length()) {
            int startIndex = text.indexOf("<##", index);
            if (startIndex == -1) {
                result.append(text.substring(index));
                break;
            }
            result.append(text, index, startIndex);
            if (startIndex + 9 <= text.length() && text.charAt(startIndex + 9) == '>') {
                String hexColor = text.substring(startIndex + 3, startIndex + 9);
                if (HEX_COLOR_PATTERN.matcher(hexColor).matches()) {
                    result.append("<#").append(hexColor).append(">");
                    index = startIndex + 10;
                    continue;
                }
                result.append("<##").append(hexColor).append(">");
                index = startIndex + 10;
                continue;
            }
            result.append("<##");
            index = startIndex + 3;
        }
        return result.toString();
    }

    private boolean isHexColorStandalone(String text, int index) {
        int nextChar;
        if (index + 6 >= text.length()) {
            return false;
        }
        int prevChar = index == 0 ? 32 : (int)text.charAt(index - 1);
        int n = nextChar = index + 7 >= text.length() ? 32 : (int)text.charAt(index + 7);
        if (prevChar == 38) {
            return false;
        }
        if (prevChar == 60 && nextChar == 62) {
            return false;
        }
        if (prevChar == 47 && nextChar == 62) {
            return false;
        }
        if (prevChar == 58 && (nextChar == 62 || nextChar == 58)) {
            return false;
        }
        return this.isHexPattern(text, index + 1);
    }

    private void handleClosing(List<String> order, StringBuilder builder, boolean closeLast, boolean fastReset) {
        if (fastReset && order.size() > 1) {
            builder.append("<reset>");
        } else {
            int until;
            int n = until = closeLast ? 0 : 1;
            for (int i = order.size() - 1; i >= until; --i) {
                builder.append("</").append(order.get(i)).append('>');
            }
        }
        order.clear();
    }

    @Nullable
    private String tagByChar(char ch, Collection<Option> options) {
        if (this.isHexDigit(ch)) {
            if (!options.contains((Object)Option.COLOR)) {
                return null;
            }
            return this.colorByChar(ch);
        }
        if (this.isHexPrefix(ch)) {
            if (!options.contains((Object)Option.COLOR)) {
                return null;
            }
            return "hex_color";
        }
        if (this.isFormatChar(ch)) {
            if (!options.contains((Object)Option.FORMAT)) {
                return null;
            }
            return switch (ch) {
                case 'K', 'k' -> "obf";
                case 'L', 'l' -> "b";
                case 'M', 'm' -> "st";
                case 'N', 'n' -> "u";
                case 'O', 'o' -> "i";
                default -> throw new IllegalStateException("Provided impossible format symbol '" + ch + "'");
            };
        }
        if (ch == 'r' || ch == 'R') {
            if (!options.contains((Object)Option.RESET)) {
                return null;
            }
            return "reset";
        }
        if (ch == '@') {
            if (!options.contains((Object)Option.GRADIENT)) {
                return null;
            }
            return "gradient";
        }
        return null;
    }

    @Nullable
    private String colorByChar(char ch) {
        return switch (ch) {
            case '0' -> "black";
            case '1' -> "dark_blue";
            case '2' -> "dark_green";
            case '3' -> "dark_aqua";
            case '4' -> "dark_red";
            case '5' -> "dark_purple";
            case '6' -> "gold";
            case '7' -> "gray";
            case '8' -> "dark_gray";
            case '9' -> "blue";
            case 'A', 'a' -> "green";
            case 'B', 'b' -> "aqua";
            case 'C', 'c' -> "red";
            case 'D', 'd' -> "light_purple";
            case 'E', 'e' -> "yellow";
            case 'F', 'f' -> "white";
            default -> null;
        };
    }

    private boolean isHexPattern(String str, int from) {
        int end = from + 6;
        for (int index = from; index < end; ++index) {
            if (this.isHexDigit(str.charAt(index))) continue;
            return false;
        }
        return true;
    }

    private boolean isHexDigit(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
            default -> false;
        };
    }

    private boolean isHexPrefix(char ch) {
        return switch (ch) {
            case '#', 'X', 'x' -> true;
            default -> false;
        };
    }

    private boolean isFormatChar(char ch) {
        return switch (ch) {
            case 'K', 'L', 'M', 'N', 'O', 'k', 'l', 'm', 'n', 'o' -> true;
            default -> false;
        };
    }

    @Inject
    @Generated
    public LegacyColorConvertor(@Named(value="legacyColorMessage") Cache<String, String> messageCache, FileResolver fileResolver, PermissionChecker permissionChecker, FLogger fLogger) {
        this.messageCache = messageCache;
        this.fileResolver = fileResolver;
        this.permissionChecker = permissionChecker;
        this.fLogger = fLogger;
    }

    public static enum Option {
        COLOR,
        HEX_COLOR_STANDALONE,
        COLOR_DOUBLE_HASH,
        VERBOSE_HEX_COLOR,
        FORMAT,
        GRADIENT,
        FAST_RESET,
        RESET,
        CLOSE_COLORS,
        DOUBLE_TO_ESCAPE;

    }
}

