/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.fcolor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.fcolor.listener.FColorPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class FColorModule
extends AbstractModule {
    private static final Pattern FCOLOR_PATTERN = Pattern.compile("(<fcolor:(\\d+)>)|(</fcolor(:\\d+)?>)");
    private final FileResolver fileResolver;
    private final PermissionChecker permissionChecker;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.permission().getColors().forEach((key, value) -> this.registerPermission((Permission.IPermission)value));
        this.listenerRegistry.register(FColorPulseListener.class);
    }

    @Override
    public Message.Format.FColor config() {
        return this.fileResolver.getMessage().getFormat().getFcolor();
    }

    @Override
    public Permission.Message.Format.FColor permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getFcolor();
    }

    public Permission.Message.Format formatPermission() {
        return this.fileResolver.getPermission().getMessage().getFormat();
    }

    public void format(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE) && !this.permissionChecker.check(sender, this.formatPermission().getLegacyColors())) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        if (this.isModuleDisabledFor(receiver)) {
            return;
        }
        HashMap<Integer, String> colorsMap = new HashMap<Integer, String>(this.config().getDefaultColors());
        this.updateColorsMap(colorsMap, receiver, FColor.Type.SEE);
        if (messageContext.isFlag(MessageFlag.SENDER_COLOR_OUT)) {
            if (sender instanceof FPlayer) {
                FPlayer fPlayer = (FPlayer)sender;
                this.updateColorsMap(colorsMap, fPlayer, FColor.Type.OUT);
            }
        } else {
            this.updateColorsMap(colorsMap, receiver, FColor.Type.OUT);
        }
        String contextMessage = messageContext.getMessage();
        String formattedMessage = this.replaceFColorPlaceholders(contextMessage, colorsMap);
        messageContext.setMessage(formattedMessage);
    }

    private String replaceFColorPlaceholders(String contextMessage, Map<Integer, String> colorsMap) {
        Matcher matcher = FCOLOR_PATTERN.matcher(contextMessage);
        StringBuilder stringBuilder = new StringBuilder(contextMessage.length());
        int lastEnd = 0;
        while (matcher.find()) {
            stringBuilder.append(contextMessage, lastEnd, matcher.start());
            if (matcher.group(1) != null) {
                int number = Integer.parseInt(matcher.group(2));
                String color = colorsMap.get(number);
                stringBuilder.append(color != null ? color : "");
            }
            lastEnd = matcher.end();
        }
        stringBuilder.append(contextMessage.substring(lastEnd));
        return stringBuilder.toString();
    }

    private void updateColorsMap(Map<Integer, String> colorsMap, FPlayer fPlayer, FColor.Type type) {
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission().getColors().get((Object)type))) {
            colorsMap.putAll(fPlayer.getFColors(type));
        }
    }

    @Inject
    @Generated
    public FColorModule(FileResolver fileResolver, PermissionChecker permissionChecker, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.permissionChecker = permissionChecker;
        this.listenerRegistry = listenerRegistry;
    }
}

