/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.newbie;

import java.io.IOException;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.processor.YamlFileProcessor;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.PlatformType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class NewbieModule
extends AbstractModuleLocalization<Localization.Message.Format.Moderation.Newbie> {
    private final FileResolver fileResolver;
    private final PermissionChecker permissionChecker;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final PlatformServerAdapter platformServerAdapter;
    private final YamlFileProcessor yamlFileProcessor;
    private final FLogger fLogger;

    @Override
    public void onEnable() {
        if (this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC && this.config().getMode() == Message.Format.Moderation.Newbie.Mode.PLAYED_TIME) {
            this.fLogger.warning("Newbie module with Mode PLAYED_TIME is not supported on Fabric, SINCE_JOIN will be used");
            this.config().setMode(Message.Format.Moderation.Newbie.Mode.SINCE_JOIN);
            try {
                this.yamlFileProcessor.save(this.fileResolver.getMessage());
            }
            catch (IOException e) {
                this.fLogger.warning(e);
            }
        }
        super.onEnable();
        this.registerPermission(this.permission().getBypass());
    }

    @Override
    public MessageType messageType() {
        return MessageType.NEWBIE;
    }

    @Override
    public Message.Format.Moderation.Newbie config() {
        return this.fileResolver.getMessage().getFormat().getModeration().getNewbie();
    }

    @Override
    public Permission.Message.Format.Moderation.Newbie permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getModeration().getNewbie();
    }

    @Override
    public Localization.Message.Format.Moderation.Newbie localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getModeration().getNewbie();
    }

    public boolean isNewBie(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return false;
        }
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission().getBypass())) {
            return false;
        }
        long timeToCheck = switch (this.config().getMode()) {
            default -> throw new MatchException(null, null);
            case Message.Format.Moderation.Newbie.Mode.SINCE_JOIN -> System.currentTimeMillis() - this.platformPlayerAdapter.getFirstPlayed(fPlayer);
            case Message.Format.Moderation.Newbie.Mode.PLAYED_TIME -> this.platformPlayerAdapter.getAllTimePlayed(fPlayer);
        };
        long timeout = this.config().getTimeout() * 1000L;
        return timeToCheck <= timeout;
    }

    public ExternalModeration getModeration(FPlayer fPlayer) {
        if (!this.isNewBie(fPlayer)) {
            return null;
        }
        long timeout = this.config().getTimeout() * 1000L;
        long firstPlayed = this.platformPlayerAdapter.getFirstPlayed(fPlayer);
        long moderationTime = switch (this.config().getMode()) {
            default -> throw new MatchException(null, null);
            case Message.Format.Moderation.Newbie.Mode.SINCE_JOIN -> firstPlayed + timeout;
            case Message.Format.Moderation.Newbie.Mode.PLAYED_TIME -> System.currentTimeMillis() + (timeout - this.platformPlayerAdapter.getAllTimePlayed(fPlayer));
        };
        return new ExternalModeration(fPlayer.getName(), FPlayer.UNKNOWN.getName(), ((Localization.Message.Format.Moderation.Newbie)this.localization()).getReason(), 1L, firstPlayed, moderationTime, false);
    }

    @Inject
    @Generated
    public NewbieModule(FileResolver fileResolver, PermissionChecker permissionChecker, PlatformPlayerAdapter platformPlayerAdapter, PlatformServerAdapter platformServerAdapter, YamlFileProcessor yamlFileProcessor, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.permissionChecker = permissionChecker;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.platformServerAdapter = platformServerAdapter;
        this.yamlFileProcessor = yamlFileProcessor;
        this.fLogger = fLogger;
    }
}

