/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.names;

import java.util.Set;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.names.listener.NamesPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@Singleton
public class NamesModule
extends AbstractModuleLocalization<Localization.Message.Format.Names> {
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final IntegrationModule integrationModule;
    private final MessagePipeline messagePipeline;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(NamesPulseListener.class);
    }

    @Override
    public Message.Format.Names config() {
        return this.fileResolver.getMessage().getFormat().getNames();
    }

    @Override
    public Permission.Message.Format.Names permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getNames();
    }

    @Override
    public MessageType messageType() {
        return MessageType.NAME;
    }

    @Override
    public Localization.Message.Format.Names localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getNames();
    }

    public void addTags(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        if (!(sender instanceof FPlayer)) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.DISPLAY_NAME, (argumentQueue, context) -> {
                Localization.Message.Format.Names localizationName = this.localization(receiver);
                Component showEntityName = sender.getShowEntityName();
                if (showEntityName == null) {
                    Component displayName = this.messagePipeline.builder(sender, receiver, StringUtils.replaceEach((String)(sender.getType().equals("UNKNOWN") ? localizationName.getUnknown() : localizationName.getEntity()), (String[])new String[]{"<name>", "<type>", "<uuid>"}, (String[])new String[]{"<lang:'" + sender.getType() + "'>", sender.getType(), sender.getUuid().toString()})).build();
                    return Tag.selfClosingInserting((Component)displayName);
                }
                Component displayName = this.messagePipeline.builder(sender, receiver, sender.getType().equals("UNKNOWN") ? localizationName.getUnknown() : StringUtils.replaceEach((String)localizationName.getEntity(), (String[])new String[]{"<type>", "<uuid>"}, (String[])new String[]{sender.getType(), sender.getUuid().toString()})).tagResolvers(TagResolver.resolver((String)"name", (args, ctx) -> Tag.selfClosingInserting((Component)showEntityName))).build();
                return Tag.selfClosingInserting((Component)displayName);
            });
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.CONSTANT, (argumentQueue, context) -> {
            String constantName = fPlayer.getConstantName();
            if (constantName == null) {
                constantName = this.localization(fPlayer).getConstant();
            }
            if (constantName.isEmpty()) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.preProcessParsed((String)this.messagePipeline.builder(fPlayer, constantName).defaultSerializerBuild());
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.DISPLAY_NAME, (argumentQueue, context) -> {
            Localization.Message.Format.Names localization = this.localization(receiver);
            String displayName = fPlayer.isUnknown() ? Strings.CS.replace(localization.getUnknown(), "<name>", fPlayer.getName()) : localization.getDisplay();
            Component displayNameComponent = this.messagePipeline.builder(sender, receiver, displayName).build();
            return Tag.selfClosingInserting((Component)displayNameComponent);
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.VAULT_PREFIX, (argumentQueue, context) -> {
            String prefix = this.integrationModule.getPrefix(fPlayer);
            if (StringUtils.isEmpty((CharSequence)prefix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String text = this.messagePipeline.builder(fPlayer, receiver, prefix).defaultSerializerBuild();
            return Tag.preProcessParsed((String)text);
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.VAULT_SUFFIX, (argumentQueue, context) -> {
            String suffix = this.integrationModule.getSuffix(fPlayer);
            if (StringUtils.isEmpty((CharSequence)suffix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String text = this.messagePipeline.builder(fPlayer, receiver, suffix).defaultSerializerBuild();
            return Tag.preProcessParsed((String)text);
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.PLAYER, (argumentQueue, context) -> Tag.preProcessParsed((String)fPlayer.getName()));
    }

    public void addInvisibleTag(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(Set.of(MessagePipeline.ReplacementTag.DISPLAY_NAME, MessagePipeline.ReplacementTag.PLAYER), (argumentQueue, context) -> {
            String formatInvisible = this.localization(receiver).getInvisible();
            Component name = this.messagePipeline.builder(sender, receiver, formatInvisible).build();
            return Tag.selfClosingInserting((Component)name);
        });
    }

    @Inject
    @Generated
    public NamesModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, IntegrationModule integrationModule, MessagePipeline messagePipeline) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.integrationModule = integrationModule;
        this.messagePipeline = messagePipeline;
    }
}

