/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.object;

import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.object.listener.ObjectPulseListener;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;

@Singleton
public class ObjectModule
extends AbstractModule {
    private static final Component DEFAULT_OBJECT_COMPONENT = Component.text((String)"\u2610").color((TextColor)NamedTextColor.WHITE);
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final PermissionChecker permissionChecker;
    private final SkinService skinService;
    private final PacketProvider packetProvider;
    private final IntegrationModule integrationModule;
    @Named(value="isNewerThanOrEqualsV_1_21_9")
    private final boolean isNewerThanOrEqualsV_1_21_9;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getPlayerHead());
        this.registerPermission(this.permission().getSprite());
        this.listenerRegistry.register(ObjectPulseListener.class);
    }

    @Override
    public Message.Format.Object config() {
        return this.fileResolver.getMessage().getFormat().getObject();
    }

    @Override
    public Permission.Message.Format.Object permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getObject();
    }

    public void addPlayerHeadTag(MessageContext messageContext) {
        if (!this.config().isPlayerHead()) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            if (this.isModuleDisabledFor(sender)) {
                return;
            }
            if (!this.permissionChecker.check(sender, this.permission().getPlayerHead())) {
                return;
            }
        }
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.PLAYER_HEAD, (argumentQueue, context) -> {
            String playerHead;
            Tag receiverVersionTag = this.checkAndGetReceiverTag(messageContext);
            if (receiverVersionTag != null) {
                return receiverVersionTag;
            }
            PlayerHeadObjectContents.Builder playerHeadBuilderComponent = ObjectContents.playerHead();
            String string = playerHead = argumentQueue.hasNext() ? argumentQueue.pop().value() : null;
            if (playerHead == null) {
                PlayerHeadObjectContents.ProfileProperty profileProperty = this.skinService.getProfilePropertyFromCache(sender);
                Component playerHeadComponent = ((ObjectComponent)Component.object().contents((ObjectContents)playerHeadBuilderComponent.name(sender.getName()).id(sender.getUuid()).profileProperty(profileProperty).build()).build()).color((TextColor)NamedTextColor.WHITE);
                if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
                    playerHeadComponent = playerHeadComponent.append((Component)Component.space());
                }
                return Tag.selfClosingInserting((Component)playerHeadComponent);
            }
            try {
                playerHeadBuilderComponent.id(UUID.fromString(playerHead));
            }
            catch (IllegalArgumentException e) {
                playerHeadBuilderComponent.name(playerHead);
            }
            boolean showPlayerHat = !argumentQueue.hasNext() || Boolean.parseBoolean(argumentQueue.pop().value());
            Component playerHeadComponent = ((ObjectComponent)Component.object().contents((ObjectContents)playerHeadBuilderComponent.hat(showPlayerHat).build()).build()).color((TextColor)NamedTextColor.WHITE);
            return Tag.selfClosingInserting((Component)playerHeadComponent);
        });
    }

    public void addSpriteTag(MessageContext messageContext) {
        if (!this.config().isSprite()) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            if (this.isModuleDisabledFor(sender)) {
                return;
            }
            if (!this.permissionChecker.check(sender, this.permission().getSprite())) {
                return;
            }
        }
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.SPRITE, (argumentQueue, context) -> {
            Tag receiverVersionTag = this.checkAndGetReceiverTag(messageContext);
            if (receiverVersionTag != null) {
                return receiverVersionTag;
            }
            if (!argumentQueue.hasNext()) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            Key sprite = Key.key((String)argumentQueue.pop().value());
            Tag.Argument secondArgument = argumentQueue.peek();
            SpriteObjectContents spriteObjectContents = secondArgument == null ? ObjectContents.sprite((Key)sprite) : ObjectContents.sprite((Key)sprite, (Key)Key.key((String)secondArgument.value()));
            Component spriteComponent = ((ObjectComponent)Component.object().contents((ObjectContents)spriteObjectContents).build()).color((TextColor)NamedTextColor.WHITE);
            if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
                spriteComponent = spriteComponent.append((Component)Component.space());
            }
            return Tag.selfClosingInserting((Component)spriteComponent);
        });
    }

    private Tag checkAndGetReceiverTag(MessageContext messageContext) {
        FPlayer fReceiver = messageContext.getReceiver();
        if (this.isNewerThanOrEqualsV_1_21_9 && fReceiver.isUnknown()) {
            if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
                return Tag.selfClosingInserting((Component)DEFAULT_OBJECT_COMPONENT);
            }
            return Tag.selfClosingInserting((Component)DEFAULT_OBJECT_COMPONENT.append((Component)Component.space()));
        }
        if (fReceiver.isUnknown()) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        if (this.packetProvider.isNewerThanOrEquals(fReceiver, ClientVersion.V_1_21_9)) {
            if (this.integrationModule.isBedrockPlayer(fReceiver)) {
                return messageContext.isFlag(MessageFlag.USER_MESSAGE) ? Tag.selfClosingInserting((Component)DEFAULT_OBJECT_COMPONENT) : Tag.selfClosingInserting((Component)Component.empty());
            }
            return null;
        }
        return Tag.selfClosingInserting((Component)Component.empty());
    }

    @Inject
    @Generated
    public ObjectModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, PermissionChecker permissionChecker, SkinService skinService, PacketProvider packetProvider, IntegrationModule integrationModule, @Named(value="isNewerThanOrEqualsV_1_21_9") boolean isNewerThanOrEqualsV_1_21_9) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.permissionChecker = permissionChecker;
        this.skinService = skinService;
        this.packetProvider = packetProvider;
        this.integrationModule = integrationModule;
        this.isNewerThanOrEqualsV_1_21_9 = isNewerThanOrEqualsV_1_21_9;
    }
}

