/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.questionanswer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.questionanswer.listener.QuestionAnswerPulseListener;
import net.flectone.pulse.module.message.format.questionanswer.model.QuestionAnswerMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;

@Singleton
public class QuestionAnswerModule
extends AbstractModuleLocalization<Localization.Message.Format.QuestionAnswer> {
    private final Map<UUID, Boolean> processedQuestions = new WeakHashMap<UUID, Boolean>();
    private final Map<String, Sound> soundMap = new HashMap<String, Sound>();
    private final Map<String, Cooldown> cooldownMap = new HashMap<String, Cooldown>();
    private final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();
    private final FileResolver fileResolver;
    private final FLogger fLogger;
    private final ListenerRegistry listenerRegistry;
    private final PermissionChecker permissionChecker;

    @Override
    public void onEnable() {
        super.onEnable();
        this.config().getQuestions().forEach((key, questionMessage) -> {
            try {
                this.patternMap.put((String)key, Pattern.compile(questionMessage.getTarget()));
            }
            catch (PatternSyntaxException e) {
                this.fLogger.warning(e);
            }
            Permission.Message.Format.QuestionAnswer.Question questionPermission = this.permission().getQuestions().get(key);
            if (questionPermission == null) {
                return;
            }
            this.registerPermission(questionPermission.getAsk());
            this.soundMap.put((String)key, this.createSound(questionMessage.getSound(), questionPermission.getSound()));
            this.cooldownMap.put((String)key, this.createCooldown(questionMessage.getCooldown(), questionPermission.getCooldownBypass()));
        });
        this.listenerRegistry.register(QuestionAnswerPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.processedQuestions.clear();
        this.soundMap.clear();
        this.cooldownMap.clear();
        this.patternMap.clear();
    }

    @Override
    public MessageType messageType() {
        return MessageType.QUESTION_ANSWER;
    }

    @Override
    public Message.Format.QuestionAnswer config() {
        return this.fileResolver.getMessage().getFormat().getQuestionAnswer();
    }

    @Override
    public Permission.Message.Format.QuestionAnswer permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getQuestionAnswer();
    }

    @Override
    public Localization.Message.Format.QuestionAnswer localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getQuestionAnswer();
    }

    public void format(MessageContext messageContext) {
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        StringBuilder result = new StringBuilder(contextMessage);
        for (Map.Entry<String, Pattern> entry : this.patternMap.entrySet()) {
            Cooldown cooldown;
            Matcher matcher;
            Permission.Message.Format.QuestionAnswer.Question questionPermission = this.permission().getQuestions().get(entry.getKey());
            if (questionPermission != null && !this.permissionChecker.check(sender, questionPermission.getAsk()) || !(matcher = entry.getValue().matcher(contextMessage)).find() || (cooldown = this.cooldownMap.get(entry.getKey())) != null && cooldown.isCooldown(sender.getUuid())) continue;
            result.append("<question:'").append(entry.getKey()).append("'>");
        }
        messageContext.setMessage(result.toString());
    }

    public void addTag(MessageContext messageContext) {
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        UUID processId = messageContext.getMessageUUID();
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.QUESTION, (argumentQueue, context) -> {
            Tag.Argument questionTag = argumentQueue.peek();
            if (questionTag == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String questionKey = questionTag.value();
            if (questionKey.isEmpty()) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            this.sendAnswer(processId, sender, receiver, questionKey);
            return Tag.selfClosingInserting((Component)Component.empty());
        });
    }

    private void sendAnswer(UUID processId, FEntity sender, FEntity receiver, String question) {
        if (this.processedQuestions.containsKey(processId)) {
            return;
        }
        this.processedQuestions.put(processId, true);
        this.sendAnswerLater(sender, receiver, question);
    }

    @Async(delay=1L)
    private void sendAnswerLater(FEntity sender, FEntity receiver, String question) {
        Message.Format.QuestionAnswer.Question questionMessage = this.config().getQuestions().get(question);
        if (questionMessage == null) {
            return;
        }
        Range range = questionMessage.getRange();
        if (range.is(Range.Type.PLAYER) && !sender.equals(receiver)) {
            return;
        }
        if (!(receiver instanceof FPlayer)) {
            return;
        }
        FPlayer fReceiver = (FPlayer)receiver;
        this.sendMessage(((QuestionAnswerMetadata.QuestionAnswerMetadataBuilder)((QuestionAnswerMetadata.QuestionAnswerMetadataBuilder)((EventMetadata.EventMetadataBuilder)((QuestionAnswerMetadata.QuestionAnswerMetadataBuilder)((QuestionAnswerMetadata.QuestionAnswerMetadataBuilder)((QuestionAnswerMetadata.QuestionAnswerMetadataBuilder)QuestionAnswerMetadata.builder().sender(sender)).filterPlayer(fReceiver)).format((L questionAnswer) -> questionAnswer.getQuestions().getOrDefault(question, ""))).question(question)).destination(questionMessage.getDestination())).sound(this.soundMap.get(question))).build());
    }

    @Inject
    @Generated
    public QuestionAnswerModule(FileResolver fileResolver, FLogger fLogger, ListenerRegistry listenerRegistry, PermissionChecker permissionChecker) {
        this.fileResolver = fileResolver;
        this.fLogger = fLogger;
        this.listenerRegistry = listenerRegistry;
        this.permissionChecker = permissionChecker;
    }
}

