/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.scoreboard;

import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.scoreboard.listener.ScoreboardPulseListener;
import net.flectone.pulse.module.message.format.scoreboard.model.Team;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

@Singleton
public class ScoreboardModule
extends AbstractModule {
    private final Map<UUID, Team> uuidTeamMap = new ConcurrentHashMap<UUID, Team>();
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final MessagePipeline messagePipeline;
    private final PacketSender packetSender;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        Ticker ticker = this.config().getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.uuidTeamMap.keySet().forEach(uuid -> {
                FPlayer fPlayer = this.fPlayerService.getFPlayer((UUID)uuid);
                Team newTeam = this.createTeam(fPlayer);
                this.sendPacket(newTeam, WrapperPlayServerTeams.TeamMode.UPDATE);
                this.uuidTeamMap.put((UUID)uuid, newTeam);
            }), ticker.getPeriod());
        }
        this.listenerRegistry.register(ScoreboardPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.uuidTeamMap.values().forEach(team -> this.sendPacket((Team)team, WrapperPlayServerTeams.TeamMode.REMOVE));
        this.uuidTeamMap.clear();
    }

    @Override
    public Message.Format.Scoreboard config() {
        return this.fileResolver.getMessage().getFormat().getScoreboard();
    }

    @Override
    public Permission.Message.Format.Scoreboard permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getScoreboard();
    }

    @Async
    public void create(FPlayer fPlayer, boolean skipCacheTeam) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!skipCacheTeam) {
            this.uuidTeamMap.values().forEach(cacheTeam -> this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerTeams(cacheTeam.name(), WrapperPlayServerTeams.TeamMode.CREATE, cacheTeam.info(), List.of(cacheTeam.owner()))));
        }
        Team team = this.createTeam(fPlayer);
        this.sendPacket(team, WrapperPlayServerTeams.TeamMode.CREATE);
        this.uuidTeamMap.put(fPlayer.getUuid(), team);
    }

    public boolean hasTeam(FPlayer fPlayer) {
        return this.uuidTeamMap.containsKey(fPlayer.getUuid());
    }

    @Async
    public void remove(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Team team = this.uuidTeamMap.get(fPlayer.getUuid());
        if (team == null) {
            return;
        }
        this.uuidTeamMap.remove(fPlayer.getUuid());
        this.sendPacket(team, WrapperPlayServerTeams.TeamMode.REMOVE);
    }

    private Team createTeam(FPlayer fPlayer) {
        String teamName = this.fPlayerService.getSortedName(fPlayer);
        TextComponent displayName = Component.text((String)teamName);
        TextComponent prefix = Component.empty();
        if (!this.config().getPrefix().isEmpty()) {
            prefix = this.messagePipeline.builder(fPlayer, this.config().getPrefix()).flag(MessageFlag.INVISIBLE_NAME, false).build();
        }
        TextComponent suffix = Component.empty();
        if (!this.config().getSuffix().isEmpty()) {
            suffix = this.messagePipeline.builder(fPlayer, this.config().getSuffix()).flag(MessageFlag.INVISIBLE_NAME, false).build();
        }
        WrapperPlayServerTeams.NameTagVisibility nameTagVisibility = this.config().isNameVisible() ? WrapperPlayServerTeams.NameTagVisibility.ALWAYS : WrapperPlayServerTeams.NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
        WrapperPlayServerTeams.CollisionRule collisionRule = WrapperPlayServerTeams.CollisionRule.ALWAYS;
        TextColor color = this.messagePipeline.builder(fPlayer, this.config().getColor()).build().color();
        WrapperPlayServerTeams.OptionData optionData = WrapperPlayServerTeams.OptionData.NONE;
        WrapperPlayServerTeams.ScoreBoardTeamInfo info = new WrapperPlayServerTeams.ScoreBoardTeamInfo((Component)displayName, (Component)prefix, (Component)suffix, nameTagVisibility, collisionRule, color == null ? NamedTextColor.WHITE : NamedTextColor.nearestTo((TextColor)color), optionData);
        return new Team(teamName, fPlayer.getName(), info);
    }

    private void sendPacket(Team team, WrapperPlayServerTeams.TeamMode teamMode) {
        this.packetSender.send((PacketWrapper<?>)new WrapperPlayServerTeams(team.name(), teamMode, team.info(), List.of(team.owner())));
    }

    @Inject
    @Generated
    public ScoreboardModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, MessagePipeline messagePipeline, PacketSender packetSender, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.messagePipeline = messagePipeline;
        this.packetSender = packetSender;
        this.listenerRegistry = listenerRegistry;
    }
}

