/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.translate;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.translate.listener.TranslatePulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.jetbrains.annotations.Nullable;

@Singleton
public class TranslateModule
extends AbstractModuleLocalization<Localization.Message.Format.Translate> {
    @Named(value="translateMessage")
    private final Cache<String, UUID> messageCache;
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(TranslatePulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.messageCache.invalidateAll();
    }

    @Override
    public MessageType messageType() {
        return MessageType.TRANSLATE;
    }

    @Override
    public Message.Format.Translate config() {
        return this.fileResolver.getMessage().getFormat().getTranslate();
    }

    @Override
    public Permission.Message.Format.Translate permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getTranslate();
    }

    @Override
    public Localization.Message.Format.Translate localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getTranslate();
    }

    public UUID saveMessage(String message) {
        UUID uuid = (UUID)this.messageCache.getIfPresent((Object)message);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.messageCache.put((Object)message, (Object)uuid);
        }
        return uuid;
    }

    public void addTag(MessageContext messageContext, UUID key) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(Set.of(MessagePipeline.ReplacementTag.TRANSLATE, MessagePipeline.ReplacementTag.TRANSLATETO), (argumentQueue, context) -> {
            String firstLang = "auto";
            String secondLang = receiver.getSetting(SettingText.LOCALE);
            if (argumentQueue.hasNext()) {
                Tag.Argument first = argumentQueue.pop();
                if (argumentQueue.hasNext()) {
                    Tag.Argument second = argumentQueue.pop();
                    if (argumentQueue.hasNext()) {
                        firstLang = first.value();
                        secondLang = second.value();
                    } else {
                        secondLang = first.value();
                    }
                }
            }
            String action = this.localization(receiver).getAction();
            action = Strings.CS.replaceOnce(action, "<language>", firstLang);
            action = Strings.CS.replaceOnce(action, "<language>", secondLang == null ? "ru_ru" : secondLang);
            action = Strings.CS.replace(action, "<message>", key.toString());
            Component component = this.messagePipeline.builder(sender, receiver, action).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).flag(MessageFlag.TRANSLATE, false).build();
            return Tag.selfClosingInserting((Component)component);
        });
    }

    public String getMessage(String stringUUID) {
        try {
            UUID uuid = UUID.fromString(stringUUID);
            return this.getMessage(uuid);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public String getMessage(UUID uuid) {
        return this.messageCache.asMap().entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(uuid)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    @Inject
    @Generated
    public TranslateModule(@Named(value="translateMessage") Cache<String, UUID> messageCache, FileResolver fileResolver, ListenerRegistry listenerRegistry, MessagePipeline messagePipeline) {
        this.messageCache = messageCache;
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
    }
}

