/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.world;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.world.listener.WorldPacketListener;
import net.flectone.pulse.module.message.format.world.listener.WorldPulseListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.SettingText;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;

@Singleton
public class WorldModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final ListenerRegistry listenerRegistry;
    private final TaskScheduler taskScheduler;
    private final PacketProvider packetProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        Ticker ticker = this.config().getTicker();
        if (ticker.isEnable() || this.packetProvider.getServerVersion().isOlderThan(ServerVersion.V_1_9)) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::update), ticker.getPeriod());
        }
        this.listenerRegistry.register(WorldPacketListener.class);
        this.listenerRegistry.register(WorldPulseListener.class);
    }

    @Override
    public Message.Format.World config() {
        return this.fileResolver.getMessage().getFormat().getWorld();
    }

    @Override
    public Permission.Message.Format.World permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getWorld();
    }

    public void addTag(MessageContext messageContext) {
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (!(sender instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.WORLD_PREFIX, (argumentQueue, context) -> {
            String worldPrefix = fPlayer.getSetting(SettingText.WORLD_PREFIX);
            if (worldPrefix == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.preProcessParsed((String)worldPrefix);
        });
    }

    @Async
    public void update(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String newWorldPrefix = this.config().getMode() == Mode.TYPE ? this.config().getValues().get(this.platformPlayerAdapter.getWorldEnvironment(fPlayer)) : this.config().getValues().get(this.platformPlayerAdapter.getWorldName(fPlayer));
        String fPlayerWorldPrefix = fPlayer.getSetting(SettingText.WORLD_PREFIX);
        if (newWorldPrefix == null && fPlayerWorldPrefix == null) {
            return;
        }
        if (newWorldPrefix != null && newWorldPrefix.equalsIgnoreCase(fPlayerWorldPrefix)) {
            return;
        }
        fPlayer.setSetting(SettingText.WORLD_PREFIX, newWorldPrefix);
        this.fPlayerService.saveOrUpdateSetting(fPlayer, SettingText.WORLD_PREFIX);
    }

    @Inject
    @Generated
    public WorldModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, ListenerRegistry listenerRegistry, TaskScheduler taskScheduler, PacketProvider packetProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.listenerRegistry = listenerRegistry;
        this.taskScheduler = taskScheduler;
        this.packetProvider = packetProvider;
    }

    public static enum Mode {
        TYPE,
        NAME;

    }
}

