/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.join;

import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.join.listener.JoinPulseListener;
import net.flectone.pulse.module.message.join.model.JoinMetadata;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class JoinModule
extends AbstractModuleLocalization<Localization.Message.Join> {
    private final FileResolver fileResolver;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final IntegrationModule integrationModule;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.createSound(this.config().getSound(), this.permission().getSound());
        this.listenerRegistry.register(JoinPulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.JOIN;
    }

    @Override
    public Message.Join config() {
        return this.fileResolver.getMessage().getJoin();
    }

    @Override
    public Permission.Message.Join permission() {
        return this.fileResolver.getPermission().getMessage().getJoin();
    }

    @Override
    public Localization.Message.Join localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getJoin();
    }

    @Async(delay=5L)
    public void sendLater(FPlayer fPlayer) {
        this.send(fPlayer, false);
    }

    @Async
    public void send(FPlayer fPlayer, boolean ignoreVanish) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        boolean hasPlayedBefore = this.platformPlayerAdapter.hasPlayedBefore(fPlayer);
        this.sendMessage(((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((EventMetadata.EventMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)JoinMetadata.builder().sender(fPlayer)).format(s -> hasPlayedBefore || !this.config().isFirst() ? s.getFormat() : s.getFormatFirstTime())).ignoreVanish(ignoreVanish)).playedBefore(hasPlayedBefore)).destination(this.config().getDestination())).range(this.config().getRange())).sound(this.getModuleSound())).filter(fReceiver -> ignoreVanish || this.integrationModule.canSeeVanished(fPlayer, (FEntity)fReceiver))).proxy(dataOutputStream -> {
            dataOutputStream.writeBoolean(hasPlayedBefore);
            dataOutputStream.writeBoolean(ignoreVanish);
        })).integration()).build());
    }

    @Inject
    @Generated
    public JoinModule(FileResolver fileResolver, PlatformPlayerAdapter platformPlayerAdapter, IntegrationModule integrationModule, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.integrationModule = integrationModule;
        this.listenerRegistry = listenerRegistry;
    }
}

