/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.objective;

import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.objective.ScoreboardPosition;
import net.flectone.pulse.module.message.objective.belowname.BelownameModule;
import net.flectone.pulse.module.message.objective.tabname.TabnameModule;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ObjectiveModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final PacketSender packetSender;

    @Override
    public void configureChildren() {
        super.configureChildren();
        this.addChildren(BelownameModule.class);
        this.addChildren(TabnameModule.class);
    }

    @Override
    public Message.Objective config() {
        return this.fileResolver.getMessage().getObjective();
    }

    @Override
    public Permission.Message.Objective permission() {
        return this.fileResolver.getPermission().getMessage().getObjective();
    }

    public void createObjective(FPlayer fPlayer, @Nullable Component displayName, ScoreboardPosition scoreboardPosition) {
        this.removeObjective(fPlayer, scoreboardPosition);
        String objectiveName = scoreboardPosition.name() + String.valueOf(fPlayer.getUuid());
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerScoreboardObjective(objectiveName, WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE, (Component)(displayName == null ? Component.text((String)objectiveName) : displayName), WrapperPlayServerScoreboardObjective.RenderType.INTEGER, null));
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerDisplayScoreboard(scoreboardPosition.ordinal(), objectiveName));
    }

    public void updateObjective(FPlayer fPlayer, FPlayer fObjective, int score, ScoreboardPosition scoreboardPosition) {
        String objectiveName = scoreboardPosition.name() + String.valueOf(fPlayer.getUuid());
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerUpdateScore(fObjective.getName(), WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, objectiveName, score, (Component)Component.text((String)fPlayer.getName()), null));
    }

    public void removeObjective(FPlayer fPlayer, ScoreboardPosition scoreboardPosition) {
        String objectiveName = scoreboardPosition.name() + String.valueOf(fPlayer.getUuid());
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerScoreboardObjective(objectiveName, WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE, (Component)Component.empty(), null, null));
    }

    @Inject
    @Generated
    public ObjectiveModule(FileResolver fileResolver, PacketSender packetSender) {
        this.fileResolver = fileResolver;
        this.packetSender = packetSender;
    }

    public static enum Mode {
        HEALTH,
        LEVEL,
        FOOD,
        PING,
        ARMOR,
        ATTACK;

    }
}

