/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.sign;

import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@Singleton
public class SignModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final MessagePipeline messagePipeline;

    @Override
    public Message.Sign config() {
        return this.fileResolver.getMessage().getSign();
    }

    @Override
    public Permission.Message.Sign permission() {
        return this.fileResolver.getPermission().getMessage().getSign();
    }

    public String format(FPlayer fPlayer, String string) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        try {
            TextComponent deserialized = LegacyComponentSerializer.legacySection().deserialize(string);
            Component component = this.messagePipeline.builder(fPlayer, Strings.CS.replace(string, "\u00a7", "&")).flag(MessageFlag.USER_MESSAGE, true).build().mergeStyle((Component)deserialized);
            return LegacyComponentSerializer.legacySection().serialize(component);
        }
        catch (ParsingException parsingException) {
            return string;
        }
    }

    @Inject
    @Generated
    public SignModule(FileResolver fileResolver, MessagePipeline messagePipeline) {
        this.fileResolver = fileResolver;
        this.messagePipeline = messagePipeline;
    }
}

