/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.motd;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class MOTDModule
extends AbstractModuleListLocalization<Localization.Message.Status.MOTD> {
    private final FileResolver fileResolver;
    private final MessagePipeline messagePipeline;
    private final PacketProvider packetProvider;

    @Override
    public MessageType messageType() {
        return MessageType.MOTD;
    }

    @Override
    public Message.Status.MOTD config() {
        return this.fileResolver.getMessage().getStatus().getMotd();
    }

    @Override
    public Permission.Message.Status.MOTD permission() {
        return this.fileResolver.getPermission().getMessage().getStatus().getMotd();
    }

    @Override
    public Localization.Message.Status.MOTD localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getStatus().getMotd();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return this.localization(fPlayer).getValues();
    }

    public JsonElement next(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        String nextMessage = this.getNextMessage(fPlayer, this.config().isRandom());
        if (nextMessage == null) {
            return null;
        }
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
            return this.messagePipeline.builder(fPlayer, nextMessage).jsonSerializerBuild();
        }
        String serializedText = this.messagePipeline.builder(fPlayer, nextMessage).legacySerializerBuild();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", serializedText);
        return jsonObject;
    }

    @Inject
    @Generated
    public MOTDModule(FileResolver fileResolver, MessagePipeline messagePipeline, PacketProvider packetProvider) {
        this.fileResolver = fileResolver;
        this.messagePipeline = messagePipeline;
        this.packetProvider = packetProvider;
    }
}

