/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.vanilla;

import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDeathCombatEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.vanilla.extractor.Extractor;
import net.flectone.pulse.module.message.vanilla.listener.VanillaPulseListener;
import net.flectone.pulse.module.message.vanilla.model.ParsedComponent;
import net.flectone.pulse.module.message.vanilla.model.VanillaMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@Singleton
public class VanillaModule
extends AbstractModuleLocalization<Localization.Message.Vanilla> {
    private final FileResolver fileResolver;
    private final Extractor extractor;
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;
    private final FPlayerService fPlayerService;
    private final PacketSender packetSender;

    @Override
    public void onEnable() {
        super.onEnable();
        this.extractor.reload();
        this.listenerRegistry.register(VanillaPulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.VANILLA;
    }

    @Override
    public Message.Vanilla config() {
        return this.fileResolver.getMessage().getVanilla();
    }

    @Override
    public Permission.Message.Vanilla permission() {
        return this.fileResolver.getPermission().getMessage().getVanilla();
    }

    @Override
    public Localization.Message.Vanilla localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getVanilla();
    }

    @Async
    public void send(FPlayer fPlayer, ParsedComponent parsedComponent) {
        FEntity target;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Range range = parsedComponent.vanillaMessage().getRange();
        if (parsedComponent.translationKey().startsWith("death.")) {
            target = this.getDeathTarget(parsedComponent);
            if (target instanceof FPlayer) {
                if (!target.equals(fPlayer)) {
                    if (parsedComponent.vanillaMessage().isMultiMessage()) {
                        return;
                    }
                } else {
                    String format = StringUtils.defaultString((String)this.localization(fPlayer).getTypes().get(parsedComponent.translationKey()));
                    Component component = this.messagePipeline.builder(fPlayer, format).tagResolvers(this.tagResolvers(fPlayer, parsedComponent)).build();
                    this.sendPersonalDeath(fPlayer, component);
                }
            } else {
                range = Range.get(Range.Type.PLAYER);
            }
        } else if (parsedComponent.vanillaMessage().isMultiMessage() && (target = this.getDeathTarget(parsedComponent)) != null && !fPlayer.equals(target)) {
            return;
        }
        String vanillaMessageName = parsedComponent.vanillaMessage().getName();
        this.sendMessage(((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((EventMetadata.EventMetadataBuilder)VanillaMetadata.builder().parsedComponent(parsedComponent)).sender(fPlayer)).format(localization -> StringUtils.defaultString((String)localization.getTypes().get(parsedComponent.translationKey())))).tagResolvers(fResolver -> this.tagResolvers((FPlayer)fResolver, parsedComponent))).range(range)).filter(fResolver -> vanillaMessageName.isEmpty() || fResolver.isSetting(vanillaMessageName))).destination(parsedComponent.vanillaMessage().getDestination())).integration()).proxy(dataOutputStream -> {
            dataOutputStream.writeString(parsedComponent.translationKey());
            dataOutputStream.writeAsJson(parsedComponent.arguments());
        })).build());
    }

    private FEntity getDeathTarget(ParsedComponent parsedComponent) {
        FEntity fEntity;
        Object target = parsedComponent.arguments().get(0);
        return target instanceof FEntity ? (fEntity = (FEntity)target) : null;
    }

    public TagResolver[] tagResolvers(FPlayer fResolver, ParsedComponent parsedComponent) {
        ArrayList tags = new ArrayList();
        parsedComponent.arguments().forEach((index, replacement) -> {
            Object object = replacement;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FEntity.class, Component.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    FEntity fTarget = (FEntity)selector0$temp;
                    tags.add(this.targetTag("arg_" + index, fResolver, fTarget));
                    break;
                }
                case 1: {
                    Component component = (Component)selector0$temp;
                    tags.add(TagResolver.resolver((String)("arg_" + index), (argumentQueue, context) -> {
                        TranslatableComponent translatableComponent;
                        TextColor color = component.color();
                        if (NamedTextColor.GRAY.equals(component.color()) || NamedTextColor.WHITE.equals(component.color()) || NamedTextColor.AQUA.equals(component.color())) {
                            color = null;
                        }
                        if (fResolver.isUnknown() && component instanceof TranslatableComponent && (translatableComponent = (TranslatableComponent)component).key().equals("chat.square_brackets")) {
                            return Tag.selfClosingInserting((Component)((TextComponent)((TextComponent)Component.text((String)"[").color(color)).append(this.extractor.getValueComponent(component))).append((Component)Component.text((String)"]")));
                        }
                        return Tag.selfClosingInserting((Component)component.color(color));
                    }));
                    break;
                }
                default: {
                    tags.add(TagResolver.resolver((String)("arg_" + index), (argumentQueue, context) -> Tag.selfClosingInserting((Component)Component.empty())));
                }
            }
        });
        return tags.isEmpty() ? null : tags.toArray(new TagResolver[0]);
    }

    @Sync
    public void sendPersonalDeath(FPlayer fPlayer, Component component) {
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerDeathCombatEvent(this.fPlayerService.getEntityId(fPlayer), null, component));
    }

    @Inject
    @Generated
    public VanillaModule(FileResolver fileResolver, Extractor extractor, ListenerRegistry listenerRegistry, MessagePipeline messagePipeline, FPlayerService fPlayerService, PacketSender packetSender) {
        this.fileResolver = fileResolver;
        this.extractor = extractor;
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
        this.fPlayerService = fPlayerService;
        this.packetSender = packetSender;
    }
}

