/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.vanilla.extractor;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.vanilla.model.Mapping;
import net.flectone.pulse.module.message.vanilla.model.ParsedComponent;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.EntityUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.TextDecoration;

@Singleton
public class Extractor {
    private static final Map<String, Mapping> LEGACY_TRANSLATION_MAPPINGS = new HashMap<String, Mapping>(){
        {
            this.put("commands.setblock.success", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_4), "commands.setblock.success", new Mapping(serverVersion -> true, "commands.setblock.success.1_19_4", null)));
            this.put("commands.setworldspawn.success", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9), "commands.setworldspawn.success", new Mapping(serverVersion -> serverVersion.isOlderThanOrEquals(ServerVersion.V_1_16), "commands.setworldspawn.success.1_16", new Mapping(serverVersion -> true, "commands.setworldspawn.success.1_21_8", null))));
            this.put("commands.spawnpoint.success.multiple", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9), "commands.spawnpoint.success.multiple", new Mapping(serverVersion -> serverVersion.isOlderThanOrEquals(ServerVersion.V_1_14_2), "commands.spawnpoint.success.multiple.1_14_2", new Mapping(serverVersion -> true, "commands.spawnpoint.success.multiple.1_21_8", null))));
            this.put("commands.spawnpoint.success.single", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9), "commands.spawnpoint.success.single", new Mapping(serverVersion -> serverVersion.isOlderThanOrEquals(ServerVersion.V_1_14_2), "commands.spawnpoint.success.single.1_14_2", new Mapping(serverVersion -> true, "commands.spawnpoint.success.single.1_21_8", null))));
        }
    };
    private final Map<String, Message.Vanilla.VanillaMessage> translationVanillaMessages = new HashMap<String, Message.Vanilla.VanillaMessage>();
    private final EntityUtil entityUtil;
    private final FPlayerService fPlayerService;
    private final FileResolver fileResolver;
    private final PacketProvider packetProvider;

    public void reload() {
        this.translationVanillaMessages.clear();
        List<Message.Vanilla.VanillaMessage> vanillaMessages = this.fileResolver.getMessage().getVanilla().getTypes();
        vanillaMessages.forEach(vanillaMessage -> vanillaMessage.getTranslationKeys().forEach(translationKey -> this.translationVanillaMessages.put((String)translationKey, (Message.Vanilla.VanillaMessage)vanillaMessage)));
    }

    public String getOrLegacyMapping(String translationKey) {
        Mapping mapping = LEGACY_TRANSLATION_MAPPINGS.get(translationKey);
        if (mapping == null) {
            return translationKey;
        }
        return this.recursiveGetTranslationKey(mapping);
    }

    private String recursiveGetTranslationKey(Mapping mapping) {
        ServerVersion currentServerVersion = this.packetProvider.getServerVersion();
        if (mapping.predicate().test(currentServerVersion)) {
            return mapping.newTranslationKey();
        }
        Mapping nextMapping = mapping.orElse();
        if (nextMapping == null) {
            return "";
        }
        return this.recursiveGetTranslationKey(mapping.orElse());
    }

    public Message.Vanilla.VanillaMessage getVanillaMessage(String translationKey) {
        return this.translationVanillaMessages.getOrDefault(translationKey, new Message.Vanilla.VanillaMessage());
    }

    public Optional<ParsedComponent> extract(TranslatableComponent translatableComponent) {
        String translationKey = this.getOrLegacyMapping(translatableComponent.key());
        Map<String, String> localization = this.fileResolver.getLocalization().getMessage().getVanilla().getTypes();
        if (!localization.containsKey(translationKey)) {
            return Optional.empty();
        }
        Message.Vanilla.VanillaMessage vanillaMessage = this.getVanillaMessage(translationKey);
        HashMap<Integer, Object> parsedArguments = new HashMap<Integer, Object>();
        for (int i = 0; i < translatableComponent.arguments().size(); ++i) {
            Optional<FEntity> entity = this.extractFEntity(translatableComponent, i);
            if (entity.isEmpty() || entity.get().isUnknown() && entity.get().getShowEntityName() == null) {
                Optional<Component> component = this.getComponent(translatableComponent, i);
                parsedArguments.put(i, component.orElse((Component)Component.empty()));
                continue;
            }
            parsedArguments.put(i, entity.get());
        }
        ParsedComponent parsedComponent = new ParsedComponent(translationKey, vanillaMessage, parsedArguments);
        return Optional.of(parsedComponent);
    }

    public Optional<FEntity> extractFEntity(TranslatableComponent translatableComponent, int index) {
        Optional<Component> component = this.getComponent(translatableComponent, index, Component.class);
        if (component.isEmpty()) {
            return Optional.empty();
        }
        return this.extractFEntity(component.get());
    }

    public Optional<FEntity> extractFEntity(Component component) {
        HoverEvent hoverEvent = component.hoverEvent();
        if (hoverEvent == null && !component.children().isEmpty()) {
            hoverEvent = ((Component)component.children().getFirst()).hoverEvent();
        }
        if (hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent.value();
            UUID uuid = showEntity.id();
            String rawType = showEntity.type().key().value();
            if (rawType.equals("player")) {
                return Optional.of(this.fPlayerService.getFPlayer(uuid));
            }
            String type = this.entityUtil.resolveEntityTranslationKey(rawType);
            FEntity fEntity = new FEntity("UNKNOWN_FLECTONEPULSE", uuid, type);
            fEntity.setShowEntityName(showEntity.name());
            return Optional.of(fEntity);
        }
        Optional<String> optionalName = this.extractTextContentOrTranslatableKey(component);
        if (optionalName.isEmpty()) {
            return Optional.empty();
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(optionalName.get());
        return ((FEntity)fPlayer).isUnknown() ? Optional.empty() : Optional.of(fPlayer);
    }

    protected <T extends ComponentLike> Optional<T> parseComponent(Component component, Class<T> clazz) {
        if (clazz.isInstance(component)) {
            return Optional.of((ComponentLike)clazz.cast(component));
        }
        return Optional.empty();
    }

    protected <T extends ComponentLike> Optional<T> getComponent(TranslatableComponent translatableComponent, int index, Class<T> clazz) {
        List translationArguments = translatableComponent.arguments();
        if (index < translationArguments.size()) {
            return this.parseComponent(((TranslationArgument)translationArguments.get(index)).asComponent(), clazz);
        }
        return Optional.empty();
    }

    protected Optional<Component> getComponent(TranslatableComponent translatableComponent, int index) {
        return this.getComponent(translatableComponent, index, Component.class);
    }

    public Component getValueComponent(Component component) {
        Optional<Object> optional;
        Component component2 = component;
        Objects.requireNonNull(component2);
        Component component3 = component2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslatableComponent.class, TextComponent.class, TextComponent.class}, (Object)component3, n)) {
                case 0: {
                    TranslatableComponent valueTranslatableComponent = (TranslatableComponent)component3;
                    if (valueTranslatableComponent.arguments().isEmpty()) {
                        n = 1;
                        continue block5;
                    }
                    optional = Optional.of(((TranslationArgument)valueTranslatableComponent.arguments().getFirst()).asComponent());
                    break block5;
                }
                case 1: {
                    TextComponent valueTextComponent = (TextComponent)component3;
                    if (valueTextComponent.children().isEmpty()) {
                        n = 2;
                        continue block5;
                    }
                    optional = Optional.of(((Component)valueTextComponent.children().getFirst()).asComponent());
                    break block5;
                }
                case 2: {
                    TextComponent valueTextComponent = (TextComponent)component3;
                    optional = Optional.of(valueTextComponent);
                    break block5;
                }
                default: {
                    optional = Optional.empty();
                    break block5;
                }
            }
            break;
        }
        Optional<Component> component1 = optional;
        return component1.map(this::recursiveExtractValueComponent).orElseGet(Component::empty);
    }

    private Component recursiveExtractValueComponent(Component valueComponent) {
        TranslatableComponent valueTranslatableComponent;
        TextComponent valueTextComponent;
        if (!valueComponent.style().hasDecoration(TextDecoration.ITALIC) && valueComponent instanceof TextComponent && (valueTextComponent = (TextComponent)valueComponent).content().isEmpty() && !valueTextComponent.children().isEmpty()) {
            return this.recursiveExtractValueComponent((Component)valueTextComponent.children().getFirst());
        }
        if (valueComponent instanceof TranslatableComponent && (valueTranslatableComponent = (TranslatableComponent)valueComponent).key().equals("chat.square_brackets") && !valueTranslatableComponent.arguments().isEmpty()) {
            return this.recursiveExtractValueComponent(((TranslationArgument)valueTranslatableComponent.arguments().getFirst()).asComponent());
        }
        return valueComponent;
    }

    protected Optional<String> extractTextContentOrTranslatableKey(Component component) {
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            String content = textComponent.content();
            if (!StringUtils.isEmpty((CharSequence)content)) {
                return Optional.of(content);
            }
            String insertion = textComponent.insertion();
            return insertion == null ? Optional.of("") : Optional.of(insertion);
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            String key = translatableComponent.key();
            return Optional.of(key);
        }
        return Optional.empty();
    }

    @Inject
    @Generated
    public Extractor(EntityUtil entityUtil, FPlayerService fPlayerService, FileResolver fileResolver, PacketProvider packetProvider) {
        this.entityUtil = entityUtil;
        this.fPlayerService = fPlayerService;
        this.fileResolver = fileResolver;
        this.packetProvider = packetProvider;
    }
}

