/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.vanilla.listener;

import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.vanilla.VanillaModule;
import net.flectone.pulse.module.message.vanilla.extractor.Extractor;
import net.flectone.pulse.module.message.vanilla.model.ParsedComponent;
import net.kyori.adventure.text.TranslatableComponent;

@Singleton
public class VanillaPulseListener
implements PulseListener {
    private final VanillaModule vanillaModule;
    private final Extractor extractor;

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent == null) {
            return;
        }
        Optional<ParsedComponent> parsedComponent = this.extractor.extract(translatableComponent);
        if (parsedComponent.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.vanillaModule.send(event.getFPlayer(), parsedComponent.get());
    }

    @Inject
    @Generated
    public VanillaPulseListener(VanillaModule vanillaModule, Extractor extractor) {
        this.vanillaModule = vanillaModule;
        this.extractor = extractor;
    }
}

