/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.adapter;

import com.github.retrooper.packetevents.protocol.component.ComponentTypes;
import com.github.retrooper.packetevents.protocol.component.builtin.item.ItemLore;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.flectone.pulse.FabricFlectonePulse;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.tab.playerlist.PlayerlistnameModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.TpsTracker;
import net.flectone.pulse.util.constant.PlatformType;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class FabricServerAdapter
implements PlatformServerAdapter {
    private final FabricFlectonePulse fabricFlectonePulse;
    private final Provider<IntegrationModule> integrationModuleProvider;
    private final Provider<FPlayerService> fPlayerServiceProvider;
    private final Provider<MessagePipeline> messagePipelineProvider;
    private final Provider<PlayerlistnameModule> playerlistnameModuleProvider;
    @Named(value="projectPath")
    private final Path projectPath;
    private final TpsTracker tpsTracker;
    private final FLogger fLogger;

    @Override
    public void dispatchCommand(String command) {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return;
        }
        try {
            minecraftServer.method_3734().method_9235().execute(command, (Object)minecraftServer.method_3739());
        }
        catch (CommandSyntaxException e) {
            this.fLogger.warning(e);
        }
    }

    @Override
    @NotNull
    public String getTPS() {
        return String.format("%.2f", this.tpsTracker.getTPS());
    }

    @Override
    public int getMaxPlayers() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return 0;
        }
        return minecraftServer.method_3802();
    }

    @Override
    public int getOnlinePlayerCount() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return 0;
        }
        return ((PlayerlistnameModule)this.playerlistnameModuleProvider.get()).isProxyMode() ? (int)((FPlayerService)this.fPlayerServiceProvider.get()).findOnlineFPlayers().stream().filter(fPlayer -> !((IntegrationModule)this.integrationModuleProvider.get()).isVanished((FEntity)fPlayer)).count() : (int)((FPlayerService)this.fPlayerServiceProvider.get()).getOnlineFPlayers().stream().filter(fPlayer -> !fPlayer.isUnknown()).filter(fPlayer -> !((IntegrationModule)this.integrationModuleProvider.get()).isVanished((FEntity)fPlayer)).count();
    }

    @Override
    @NotNull
    public String getServerCore() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return "fabric";
        }
        return minecraftServer.getServerModName();
    }

    @Override
    @NotNull
    public String getServerUUID() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return "";
        }
        Iterator iterator = minecraftServer.method_3738().iterator();
        if (iterator.hasNext()) {
            class_3218 serverWorld = (class_3218)iterator.next();
            return serverWorld.method_27983().method_29177().toString();
        }
        return "";
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.FABRIC;
    }

    @Override
    @NotNull
    public JsonElement getMOTD() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return new JsonObject();
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", minecraftServer.method_3818());
        return jsonObject;
    }

    @Override
    public boolean hasProject(String projectName) {
        return FabricLoader.getInstance().isModLoaded(projectName.toLowerCase());
    }

    @Override
    public boolean isOnlineMode() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return false;
        }
        return minecraftServer.method_3828();
    }

    @Override
    public boolean isPrimaryThread() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return false;
        }
        return minecraftServer.method_18854();
    }

    @Override
    @NotNull
    public String getItemName(Object item) {
        String string;
        if (item instanceof class_1799) {
            class_1799 itemStack = (class_1799)item;
            string = itemStack.method_63693().getString();
        } else {
            string = "";
        }
        return string;
    }

    @Override
    @Nullable
    public InputStream getResource(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    @Override
    public void saveResource(String path) {
        InputStream resource = this.getResource(path);
        if (resource == null) {
            return;
        }
        try {
            Path targetPath = this.projectPath.resolve(path);
            if (Files.exists(targetPath, new LinkOption[0])) {
                return;
            }
            Path parentDir = targetPath.getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            Files.copy(resource, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    @Override
    @NotNull
    public Component translateItemName(Object item, boolean translatable) {
        if (!(item instanceof class_1799)) {
            return Component.empty();
        }
        class_1799 itemStack = (class_1799)item;
        if (this.getItemName(item).equalsIgnoreCase("air")) {
            return Component.translatable((String)"block.minecraft.air");
        }
        Component component = itemStack.method_65130() == null || itemStack.method_65130().getString().isBlank() ? this.createTranslatableItemName(itemStack, translatable) : this.createItemMetaName(itemStack);
        Key key = Key.key((String)itemStack.method_41409().method_55840());
        return component.hoverEvent((HoverEventSource)HoverEvent.showItem((Key)key, (int)itemStack.method_7947()));
    }

    private Component createItemMetaName(class_1799 itemStack) {
        String displayName = itemStack.method_65130().getString();
        if (displayName == null) {
            return Component.empty();
        }
        Component componentName = ((MessagePipeline)this.messagePipelineProvider.get()).builder(displayName).build();
        String clearedDisplayName = PlainTextComponentSerializer.plainText().serialize(componentName);
        return Component.text((String)clearedDisplayName).decorate(TextDecoration.ITALIC);
    }

    private Component createTranslatableItemName(class_1799 itemStack, boolean translatable) {
        TranslatableComponent itemComponent = Component.translatable((String)itemStack.method_7909().method_7876());
        return translatable ? itemComponent : GlobalTranslator.render((Component)itemComponent, (Locale)Locale.ROOT);
    }

    @Override
    @NotNull
    public ItemStack buildItemStack(FPlayer fPlayer, String material, String title, String lore) {
        String[] stringArray;
        String[] stringsLore = lore.split("<br>");
        if (stringsLore.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lore;
        } else {
            stringArray = stringsLore;
        }
        return this.buildItemStack(fPlayer, material, title, stringArray);
    }

    @Override
    @NotNull
    public ItemStack buildItemStack(FPlayer fPlayer, String material, String title, String[] lore) {
        ItemType itemMaterial = ItemTypes.getByName((String)material.toLowerCase());
        if (itemMaterial == null) {
            itemMaterial = ItemTypes.DIAMOND_BLOCK;
        }
        Component componentName = this.buildItemNameComponent(fPlayer, title);
        List componentLore = lore.length == 0 ? Collections.emptyList() : Arrays.stream(lore).map(message -> ((MessagePipeline)this.messagePipelineProvider.get()).builder(fPlayer, (String)message).build().decoration(TextDecoration.ITALIC, false)).toList();
        return new ItemStack.Builder().type(itemMaterial).component(ComponentTypes.ITEM_NAME, (Object)componentName).component(ComponentTypes.LORE, (Object)new ItemLore(componentLore)).build();
    }

    @NotNull
    private Component buildItemNameComponent(@NotNull FPlayer fPlayer, @NotNull String title) {
        return title.isEmpty() ? Component.empty() : ((MessagePipeline)this.messagePipelineProvider.get()).builder(fPlayer, title).build();
    }

    @Inject
    @Generated
    public FabricServerAdapter(FabricFlectonePulse fabricFlectonePulse, Provider<IntegrationModule> integrationModuleProvider, Provider<FPlayerService> fPlayerServiceProvider, Provider<MessagePipeline> messagePipelineProvider, Provider<PlayerlistnameModule> playerlistnameModuleProvider, @Named(value="projectPath") Path projectPath, TpsTracker tpsTracker, FLogger fLogger) {
        this.fabricFlectonePulse = fabricFlectonePulse;
        this.integrationModuleProvider = integrationModuleProvider;
        this.fPlayerServiceProvider = fPlayerServiceProvider;
        this.messagePipelineProvider = messagePipelineProvider;
        this.playerlistnameModuleProvider = playerlistnameModuleProvider;
        this.projectPath = projectPath;
        this.tpsTracker = tpsTracker;
        this.fLogger = fLogger;
    }
}

