/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.formatter;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.moderation.newbie.NewbieModule;
import net.flectone.pulse.platform.formatter.TimeFormatter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.checker.MuteChecker;

@Singleton
public class ModerationMessageFormatter {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final TimeFormatter timeFormatter;
    private final ModerationService moderationService;
    private final Provider<IntegrationModule> integrationModuleProvider;
    private final Provider<NewbieModule> newbieModuleProvider;

    public String replacePlaceholders(String message, String playerName, String moderatorName, String moderationId, String reason, String date, String time, String timeLeft) {
        return StringUtils.replaceEach((String)message, (String[])new String[]{"<player>", "<moderator>", "<id>", "<reason>", "<date>", "<time>", "<time_left>"}, (String[])new String[]{playerName, moderatorName, moderationId, reason, date, time, timeLeft});
    }

    public String replacePlaceholders(String message, FPlayer fReceiver, Moderation moderation) {
        Localization localization = this.fileResolver.getLocalization(fReceiver);
        Localization.ReasonMap constantReasons = switch (moderation.getType()) {
            default -> throw new MatchException(null, null);
            case Moderation.Type.BAN -> localization.getCommand().getBan().getReasons();
            case Moderation.Type.MUTE -> localization.getCommand().getMute().getReasons();
            case Moderation.Type.WARN -> localization.getCommand().getWarn().getReasons();
            case Moderation.Type.KICK -> localization.getCommand().getKick().getReasons();
        };
        FPlayer fTarget = this.fPlayerService.getFPlayer(moderation.getPlayer());
        FPlayer fModerator = this.fPlayerService.getFPlayer(moderation.getModerator());
        String reason = constantReasons.getConstant(moderation.getReason());
        String date = this.timeFormatter.formatDate(moderation.getDate());
        String time = moderation.isPermanent() ? localization.getTime().getPermanent() : this.timeFormatter.format(fReceiver, moderation.getOriginalTime());
        String timeLeft = moderation.isPermanent() ? localization.getTime().getPermanent() : this.timeFormatter.format(fReceiver, moderation.getRemainingTime());
        return this.replacePlaceholders(message, fTarget.getName(), fModerator.getName(), String.valueOf(moderation.getId()), reason, date, time, timeLeft);
    }

    public String replacePlaceholders(String message, FPlayer fReceiver, ExternalModeration moderation) {
        Localization localization = this.fileResolver.getLocalization(fReceiver);
        String date = this.timeFormatter.formatDate(moderation.date());
        String time = moderation.permanent() ? localization.getTime().getPermanent() : this.timeFormatter.format(fReceiver, moderation.time());
        String timeLeft = moderation.permanent() ? localization.getTime().getPermanent() : this.timeFormatter.format(fReceiver, moderation.time() - System.currentTimeMillis());
        return this.replacePlaceholders(message, moderation.playerName(), moderation.moderatorName(), String.valueOf(moderation.moderationId()), moderation.reason(), date, time, timeLeft);
    }

    public String buildMuteMessage(FPlayer fPlayer, MuteChecker.Status status) {
        String format = this.fileResolver.getLocalization(fPlayer).getCommand().getMute().getPerson();
        return switch (status) {
            case MuteChecker.Status.LOCAL -> {
                List<Moderation> mutes = this.moderationService.getValidMutes(fPlayer);
                if (mutes.isEmpty()) {
                    yield format;
                }
                yield this.replacePlaceholders(format, fPlayer, mutes.getFirst());
            }
            case MuteChecker.Status.EXTERNAL -> {
                ExternalModeration mute = ((IntegrationModule)this.integrationModuleProvider.get()).getMute(fPlayer);
                if (mute == null) {
                    yield format;
                }
                yield this.replacePlaceholders(format, fPlayer, mute);
            }
            case MuteChecker.Status.NEWBIE -> {
                ExternalModeration mute = ((NewbieModule)this.newbieModuleProvider.get()).getModeration(fPlayer);
                if (mute == null) {
                    yield format;
                }
                yield this.replacePlaceholders(format, fPlayer, mute);
            }
            default -> "";
        };
    }

    @Inject
    @Generated
    public ModerationMessageFormatter(FileResolver fileResolver, FPlayerService fPlayerService, TimeFormatter timeFormatter, ModerationService moderationService, Provider<IntegrationModule> integrationModuleProvider, Provider<NewbieModule> newbieModuleProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.timeFormatter = timeFormatter;
        this.moderationService = moderationService;
        this.integrationModuleProvider = integrationModuleProvider;
        this.newbieModuleProvider = newbieModuleProvider;
    }
}

