/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.handler;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.exception.handling.ExceptionContext;
import org.incendo.cloud.exception.parsing.NumberParseException;
import org.incendo.cloud.parser.standard.BooleanParser;
import org.incendo.cloud.parser.standard.DurationParser;
import org.incendo.cloud.parser.standard.StringParser;

@Singleton
public class CommandExceptionHandler {
    private final FileResolver fileResolver;
    private final EventDispatcher eventDispatcher;
    private final MessagePipeline messagePipeline;
    private final FLogger fLogger;

    public void handleArgumentParseException(ExceptionContext<FPlayer, ArgumentParseException> context) {
        Throwable throwable;
        FPlayer fPlayer = (FPlayer)context.context().sender();
        Localization.Command.Exception localizationException = this.fileResolver.getLocalization(fPlayer).getCommand().getException();
        Throwable throwable2 = throwable = ((ArgumentParseException)context.exception()).getCause();
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        String message = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanParser.BooleanParseException.class, NumberParseException.class, DurationParser.DurationParseException.class, StringParser.StringParseException.class}, (Object)throwable3, n)) {
            case 0 -> {
                BooleanParser.BooleanParseException e = (BooleanParser.BooleanParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseBoolean(), "<input>", e.input());
            }
            case 1 -> {
                NumberParseException e = (NumberParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseNumber(), "<input>", e.input());
            }
            case 2 -> {
                DurationParser.DurationParseException e = (DurationParser.DurationParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseNumber(), "<input>", e.input());
            }
            case 3 -> {
                StringParser.StringParseException e = (StringParser.StringParseException)throwable3;
                yield Strings.CS.replace(localizationException.getParseString(), "<input>", e.input());
            }
            default -> Strings.CS.replace(localizationException.getParseUnknown(), "<input>", String.valueOf(throwable.getMessage()));
        };
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void handleInvalidSyntaxException(ExceptionContext<FPlayer, InvalidSyntaxException> context) {
        FPlayer fPlayer = (FPlayer)context.context().sender();
        String correctSyntax = ((InvalidSyntaxException)context.exception()).correctSyntax();
        String message = StringUtils.replaceEach((String)this.fileResolver.getLocalization(fPlayer).getCommand().getException().getSyntax(), (String[])new String[]{"<correct_syntax>", "<command>"}, (String[])new String[]{correctSyntax, String.valueOf(correctSyntax.split(" ")[0])});
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void handleNoPermissionException(ExceptionContext<FPlayer, NoPermissionException> context) {
        FPlayer fPlayer = (FPlayer)context.context().sender();
        String message = this.fileResolver.getLocalization(fPlayer).getCommand().getException().getPermission();
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void handleCommandExecutionException(ExceptionContext<FPlayer, CommandExecutionException> context) {
        this.fLogger.warning(context.exception());
        FPlayer fPlayer = (FPlayer)context.context().sender();
        String message = Strings.CS.replace(this.fileResolver.getLocalization(fPlayer).getCommand().getException().getExecution(), "<exception>", ((CommandExecutionException)context.exception()).getMessage());
        this.send(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    private void send(FPlayer fPlayer, Component component) {
        this.eventDispatcher.dispatch(new MessageSendEvent(MessageType.ERROR, fPlayer, component));
    }

    @Inject
    @Generated
    public CommandExceptionHandler(FileResolver fileResolver, EventDispatcher eventDispatcher, MessagePipeline messagePipeline, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.eventDispatcher = eventDispatcher;
        this.messagePipeline = messagePipeline;
        this.fLogger = fLogger;
    }
}

