/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guava.cache.CacheBuilder;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.CacheName;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.incendo.cloud.type.tuple.Pair;

@Singleton
public class CacheRegistry {
    private final Map<CacheName, Cache<?, ?>> cacheMap = new EnumMap(CacheName.class);
    private final FileResolver fileResolver;

    public void init() {
        Arrays.stream(CacheName.values()).forEach(this::create);
    }

    public <K, V> void create(CacheName cacheName) {
        if (this.cacheMap.containsKey((Object)cacheName)) {
            throw new IllegalArgumentException("Cache already created for " + String.valueOf((Object)cacheName));
        }
        Config.Cache.CacheSetting cacheSetting = this.fileResolver.getConfig().getCache().getTypes().get((Object)cacheName);
        if (cacheSetting == null) {
            throw new IllegalArgumentException("No cache setting for " + String.valueOf((Object)cacheName));
        }
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(cacheSetting.getDuration(), cacheSetting.getTimeUnit()).maximumSize(cacheSetting.getSize()).build();
        this.cacheMap.put(cacheName, cache);
    }

    public Cache<UUID, AtomicInteger> getDialogClickCache() {
        return this.getCache(CacheName.DIALOG_CLICK);
    }

    public Cache<UUID, FPlayer> getOfflinePlayersCache() {
        return this.getCache(CacheName.OFFLINE_PLAYERS);
    }

    public Cache<Pair<UUID, Moderation.Type>, List<Moderation>> getModerationCache() {
        return this.getCache(CacheName.MODERATION);
    }

    public Cache<String, String> getLegacyColorMessageCache() {
        return this.getCache(CacheName.LEGACY_COLOR_MESSAGE);
    }

    public Cache<String, String> getMentionMessageCache() {
        return this.getCache(CacheName.MENTION_MESSAGE);
    }

    public Cache<String, String> getSwearMessageCache() {
        return this.getCache(CacheName.SWEAR_MESSAGE);
    }

    public Cache<String, String> getReplacementMessageCache() {
        return this.getCache(CacheName.REPLACEMENT_MESSAGE);
    }

    public Cache<String, Component> getReplacementImageCache() {
        return this.getCache(CacheName.REPLACEMENT_IMAGE);
    }

    public Cache<String, UUID> getTranslateMessageCache() {
        return this.getCache(CacheName.TRANSLATE_MESSAGE);
    }

    public Cache<UUID, PlayerHeadObjectContents.ProfileProperty> getProfilePropertyCache() {
        return this.getCache(CacheName.PROFILE_PROPERTY);
    }

    public <K, V> Cache<K, V> getCache(CacheName cacheName) {
        Cache<?, ?> cache = this.cacheMap.get((Object)cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No cache created for " + String.valueOf((Object)cacheName));
        }
        return cache;
    }

    @Inject
    @Generated
    public CacheRegistry(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }
}

