/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.proxy.FabricProxy;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class FabricProxyRegistry
extends ProxyRegistry {
    private final FileResolver fileResolver;
    private final Injector injector;

    @Inject
    public FabricProxyRegistry(FileResolver fileResolver, ReflectionResolver reflectionResolver, FLogger fLogger, Injector injector) {
        super(fileResolver, reflectionResolver, fLogger, injector);
        this.fileResolver = fileResolver;
        this.injector = injector;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        Config config = this.fileResolver.getConfig();
        if (config.getProxy().isBungeecord() || config.getProxy().isVelocity()) {
            this.warnIfLocalDatabase();
            FabricProxy fabricProxy = (FabricProxy)this.injector.getInstance(FabricProxy.class);
            fabricProxy.onEnable();
            this.registry(fabricProxy);
        }
    }
}

