/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.RegExUtils;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.chat.model.ChatMetadata;
import net.flectone.pulse.module.message.vanilla.model.VanillaMetadata;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;

@Singleton
public class IntegrationSender {
    private static final Pattern FINAL_CLEAR_MESSAGE_PATTERN = Pattern.compile("[\\p{C}\\p{So}\\x{E0100}-\\x{E01EF}]+");
    private final IntegrationModule integrationModule;
    private final MessagePipeline messagePipeline;

    @Async(independent=true)
    public void send(MessageType messageType, String format, EventMetadata<?> eventMetadata) {
        UnaryOperator<String> integrationOperator = eventMetadata.getIntegration();
        if (integrationOperator == null) {
            return;
        }
        if (!this.integrationModule.hasMessenger()) {
            return;
        }
        FEntity sender = eventMetadata.getSender();
        String plainFormat = this.plainSerialize(this.createFormat(format, eventMetadata));
        String plainMessage = this.plainSerialize(this.createMessage(eventMetadata));
        String finalMessage = Strings.CS.replace(plainFormat, "<message>", plainMessage);
        UnaryOperator interfaceReplaceString = s -> {
            String input = (String)integrationOperator.apply((String)s);
            if (StringUtils.isBlank((CharSequence)input)) {
                return "";
            }
            return StringUtils.replaceEach((String)this.plainSerialize(this.createFormat(input, eventMetadata)), (String[])new String[]{"<player>", "<message>", "<plain_message>", "<final_message>", "<final_clear_message>"}, (String[])new String[]{sender.getName(), eventMetadata.getMessage(), plainMessage, finalMessage, this.clearMessage(finalMessage)});
        };
        String messageName = this.createMessageName(messageType, eventMetadata);
        this.integrationModule.sendMessage(sender, messageName, interfaceReplaceString);
    }

    private Component createFormat(String text, EventMetadata<?> eventMetadata) {
        FEntity sender = eventMetadata.getSender();
        return this.messagePipeline.builder(sender, FPlayer.UNKNOWN, text).flag(MessageFlag.SENDER_COLOR_OUT, eventMetadata.isSenderColorOut()).flag(MessageFlag.TRANSLATE, false).tagResolvers(eventMetadata.getTagResolvers(FPlayer.UNKNOWN)).build();
    }

    private Component createMessage(EventMetadata<?> eventMetadata) {
        String message = eventMetadata.getMessage();
        FEntity sender = eventMetadata.getSender();
        return StringUtils.isEmpty((CharSequence)message) ? Component.empty() : this.messagePipeline.builder(sender, FPlayer.UNKNOWN, message).flag(MessageFlag.SENDER_COLOR_OUT, eventMetadata.isSenderColorOut()).flag(MessageFlag.TRANSLATE, false).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).build();
    }

    private String clearMessage(String finalMessage) {
        return RegExUtils.replaceAll((CharSequence)finalMessage, (Pattern)FINAL_CLEAR_MESSAGE_PATTERN, (String)"");
    }

    private String plainSerialize(Component component) {
        return PlainTextComponentSerializer.plainText().serialize(GlobalTranslator.render((Component)component, (Locale)Locale.ROOT));
    }

    private String createMessageName(MessageType messageType, EventMetadata<?> eventMetadata) {
        return switch (messageType) {
            case MessageType.CHAT -> {
                if (!(eventMetadata instanceof ChatMetadata)) {
                    yield "UNKNOWN";
                }
                ChatMetadata chatMetadata = (ChatMetadata)eventMetadata;
                yield messageType.name() + "_" + chatMetadata.getChatName().toUpperCase();
            }
            case MessageType.VANILLA -> {
                if (!(eventMetadata instanceof VanillaMetadata)) {
                    yield "UNKNOWN";
                }
                VanillaMetadata vanillaMetadata = (VanillaMetadata)eventMetadata;
                String vanillaMessageName = vanillaMetadata.getParsedComponent().vanillaMessage().getName();
                if (vanillaMessageName.isEmpty()) {
                    yield messageType.name();
                }
                yield vanillaMessageName.toUpperCase();
            }
            default -> messageType.name();
        };
    }

    @Inject
    @Generated
    public IntegrationSender(IntegrationModule integrationModule, MessagePipeline messagePipeline) {
        this.integrationModule = integrationModule;
        this.messagePipeline = messagePipeline;
    }
}

