/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.advancements.Advancement;
import com.github.retrooper.packetevents.protocol.advancements.AdvancementDisplay;
import com.github.retrooper.packetevents.protocol.advancements.AdvancementHolder;
import com.github.retrooper.packetevents.protocol.advancements.AdvancementProgress;
import com.github.retrooper.packetevents.protocol.advancements.AdvancementType;
import com.github.retrooper.packetevents.protocol.chat.ChatType;
import com.github.retrooper.packetevents.protocol.chat.ChatTypes;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessageLegacy;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_16;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerActionBar;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBossBar;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerListHeaderAndFooter;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAdvancements;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.BossBar;
import net.flectone.pulse.model.util.Times;
import net.flectone.pulse.model.util.Toast;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.serializer.PacketSerializer;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;

@Singleton
public class MessageSender {
    private final PacketSerializer packetSerializer;
    private final TaskScheduler taskScheduler;
    private final PacketSender packetSender;
    private final PacketProvider packetProvider;
    private final IntegrationModule integrationModule;
    private final FLogger fLogger;

    public void sendToConsole(Component component) {
        String consoleString = (String)ANSIComponentSerializer.ansi().serialize(GlobalTranslator.render((Component)component, (Locale)Locale.ROOT));
        this.fLogger.info(consoleString);
    }

    public void sendMessage(FPlayer fPlayer, Component component, boolean silent) {
        WrapperPlayServerSystemChatMessage chatPacket;
        if (fPlayer.isConsole()) {
            this.sendToConsole(component);
            return;
        }
        if (this.integrationModule.sendMessageWithInteractiveChat(fPlayer, component)) {
            return;
        }
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        ClientVersion version = user.getPacketVersion();
        if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
            chatPacket = new WrapperPlayServerSystemChatMessage(false, component);
        } else {
            ChatType type = ChatTypes.CHAT;
            ChatMessage_v1_16 message = version.isNewerThanOrEquals(ClientVersion.V_1_16) ? new ChatMessage_v1_16(component, type, new UUID(0L, 0L)) : new ChatMessageLegacy(component, type);
            chatPacket = new WrapperPlayServerChatMessage((ChatMessage)message);
        }
        this.packetSender.send(fPlayer.getUuid(), (PacketWrapper<?>)chatPacket, silent);
    }

    public void sendTitle(FPlayer fPlayer, Component title, Component subTitle, Times times) {
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        user.sendTitle(title, subTitle, times.fadeInTicks(), times.stayTicks(), times.fadeOutTicks());
    }

    public void sendActionBar(FPlayer fPlayer, Component component) {
        this.sendActionBar(fPlayer, component, 0);
    }

    public void sendActionBar(FPlayer fPlayer, Component component, int stayTicks) {
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerSystemChatMessage(true, component));
        } else if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerActionBar(component));
        } else if (this.packetProvider.getServerVersion().isNewerThan(ServerVersion.V_1_16)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerChatMessage((ChatMessage)new ChatMessage_v1_16(component, ChatTypes.GAME_INFO, fPlayer.getUuid())));
        } else if (this.packetProvider.getServerVersion().isNewerThan(ServerVersion.V_1_8_8)) {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerChatMessage((ChatMessage)new ChatMessageLegacy(component, ChatTypes.GAME_INFO)));
        } else {
            this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerChatMessage((ChatMessage)new ChatMessageLegacy((Component)Component.text((String)LegacyComponentSerializer.legacySection().serialize(component)), ChatTypes.GAME_INFO)));
        }
        if (stayTicks <= 30) {
            return;
        }
        int remainingTicks = stayTicks - 30;
        int delay = Math.min(30, remainingTicks);
        this.taskScheduler.runAsyncLater(() -> this.sendActionBar(fPlayer, component, remainingTicks), delay);
    }

    public void sendPlayerListHeaderAndFooter(FPlayer fPlayer, Component header, Component footer) {
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerPlayerListHeaderAndFooter(header, footer));
    }

    public void sendBoosBar(FPlayer fPlayer, Component component, BossBar bossBar) {
        UUID bossBarUUID = UUID.randomUUID();
        WrapperPlayServerBossBar addWrapper = new WrapperPlayServerBossBar(bossBarUUID, WrapperPlayServerBossBar.Action.ADD);
        addWrapper.setTitle(component);
        addWrapper.setHealth(bossBar.getHealth());
        addWrapper.setOverlay(bossBar.getOverlay());
        addWrapper.setColor(bossBar.getColor());
        addWrapper.setFlags(bossBar.getFlags());
        this.packetSender.send(fPlayer, (PacketWrapper<?>)addWrapper);
        this.taskScheduler.runAsyncLater(() -> {
            WrapperPlayServerBossBar removeWrapper = new WrapperPlayServerBossBar(bossBarUUID, WrapperPlayServerBossBar.Action.REMOVE);
            this.packetSender.send(fPlayer, (PacketWrapper<?>)removeWrapper);
        }, bossBar.getDuration());
    }

    public void sendBrand(FPlayer fPlayer, Component component) {
        String message = LegacyComponentSerializer.legacySection().serialize(component) + "\u00a7r";
        this.packetSender.send(fPlayer, (PacketWrapper<?>)new WrapperPlayServerPluginMessage("minecraft:brand", this.packetSerializer.serialize(message)));
    }

    public void sendToast(FPlayer fPlayer, Component title, Toast toast) {
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        ItemType itemType = ItemTypes.getByName((String)toast.icon());
        ItemStack itemStack = ItemStack.builder().type(itemType == null ? ItemTypes.DIAMOND : itemType).build();
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(title, (Component)Component.empty(), itemStack, AdvancementType.valueOf((String)toast.style().name()), null, true, false, 0.0f, 0.0f);
        String criterionName = "trigger";
        List<String> criteria = Collections.singletonList(criterionName);
        List<List<String>> requirements = Collections.singletonList(criteria);
        ResourceLocation advancementId = ResourceLocation.minecraft((String)UUID.randomUUID().toString());
        Advancement advancement = new Advancement(null, advancementDisplay, criteria, requirements, false);
        List<AdvancementHolder> advancementHolders = Collections.singletonList(new AdvancementHolder(advancementId, advancement));
        HashMap<String, AdvancementProgress.CriterionProgress> progressMap = new HashMap<String, AdvancementProgress.CriterionProgress>();
        progressMap.put(criterionName, new AdvancementProgress.CriterionProgress(Long.valueOf(System.currentTimeMillis())));
        AdvancementProgress progress = new AdvancementProgress(progressMap);
        WrapperPlayServerUpdateAdvancements showPacket = new WrapperPlayServerUpdateAdvancements(false, advancementHolders, Collections.emptySet(), Collections.singletonMap(advancementId, progress), true);
        user.sendPacket((PacketWrapper)showPacket);
        WrapperPlayServerUpdateAdvancements removePacket = new WrapperPlayServerUpdateAdvancements(false, Collections.emptyList(), Collections.singleton(advancementId), Collections.emptyMap(), false);
        user.sendPacket((PacketWrapper)removePacket);
    }

    @Inject
    @Generated
    public MessageSender(PacketSerializer packetSerializer, TaskScheduler taskScheduler, PacketSender packetSender, PacketProvider packetProvider, IntegrationModule integrationModule, FLogger fLogger) {
        this.packetSerializer = packetSerializer;
        this.taskScheduler = taskScheduler;
        this.packetSender = packetSender;
        this.packetProvider = packetProvider;
        this.integrationModule = integrationModule;
        this.fLogger = fLogger;
    }
}

