/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.platform.provider.PacketProvider;

@Singleton
public class PacketSender {
    private final PacketProvider packetProvider;

    public void send(Object channel, PacketWrapper<?> packetWrapper, boolean silent) {
        ProtocolManager protocolManager = this.packetProvider.getProtocolManager();
        if (silent) {
            protocolManager.sendPacketSilently(channel, packetWrapper);
        } else {
            protocolManager.sendPacket(channel, packetWrapper);
        }
    }

    public void send(UUID uuid, PacketWrapper<?> packetWrapper, boolean silent) {
        Object channel = this.packetProvider.getChannel(uuid);
        if (channel == null) {
            return;
        }
        this.send(channel, packetWrapper, silent);
    }

    public void send(FPlayer fPlayer, PacketWrapper<?> packetWrapper, boolean silent) {
        this.send(fPlayer.getUuid(), packetWrapper, silent);
    }

    public void send(UUID uuid, PacketWrapper<?> packetWrapper) {
        this.send(uuid, packetWrapper, false);
    }

    public void send(FPlayer fPlayer, PacketWrapper<?> packetWrapper) {
        this.send(fPlayer.getUuid(), packetWrapper, false);
    }

    public void send(PacketWrapper<?> packetWrapper) {
        this.packetProvider.getProtocolManager().getUsers().forEach(user -> user.sendPacket(packetWrapper));
    }

    @Inject
    @Generated
    public PacketSender(PacketProvider packetProvider) {
        this.packetProvider = packetProvider;
    }
}

