/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.parser.player;

import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.service.FPlayerService;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

@Singleton
public class PlayerParser
implements ArgumentParser<FPlayer, String>,
BlockingSuggestionProvider.Strings<FPlayer> {
    private final StringParser<FPlayer> stringParser = new StringParser(StringParser.StringMode.SINGLE);
    private final FPlayerService playerService;
    private final IntegrationModule integrationModule;

    @NonNull
    public ArgumentParseResult<String> parse(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.stringParser.parse(context, input);
    }

    @NonNull
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.playerService.findOnlineFPlayers().stream().filter(player -> this.integrationModule.canSeeVanished((FEntity)player, (FEntity)context.sender())).map(FEntity::getName).toList();
    }

    @Inject
    @Generated
    public PlayerParser(FPlayerService playerService, IntegrationModule integrationModule) {
        this.playerService = playerService;
        this.integrationModule = integrationModule;
    }
}

