/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.library.libby.LibraryManager;
import net.flectone.pulse.library.libby.relocation.Relocation;

public abstract class LibraryResolver {
    private final List<Library> libraries = new ArrayList<Library>();
    private final LibraryManager libraryManager;

    protected LibraryResolver(LibraryManager libraryManager) {
        this.libraryManager = libraryManager;
    }

    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    public void loadLibrary(Library library) {
        this.libraryManager.loadLibrary(library);
    }

    public void loadLibraries(List<Library> libraries) {
        libraries.forEach(this::loadLibrary);
    }

    public void loadLibraries() {
        this.loadLibraries(this.libraries);
    }

    public void resolveRepositories() {
        this.libraryManager.addRepository("https://repo1.maven.org/maven2/");
        this.libraryManager.addRepository("https://repo.codemc.io/repository/maven-releases/");
        this.libraryManager.addRepository("https://jitpack.io/");
    }

    public void addLibraries() {
        this.addLibrary(Library.builder().groupId("com{}google{}inject").artifactId("guice").version("7.0.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("com{}google{}inject").relocatedPattern("net.flectone.pulse.library.guice").build()).relocate(Relocation.builder().pattern("com{}google{}common").relocatedPattern("net.flectone.pulse.library.guava").build()).build());
        this.addLibrary(Library.builder().groupId("tools{}jackson{}dataformat").artifactId("jackson-dataformat-yaml").version("3.0.1").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("com{}fasterxml{}jackson").relocatedPattern("net.flectone.pulse.library.jackson").build()).relocate(Relocation.builder().pattern("tools{}jackson").relocatedPattern("net.flectone.pulse.library.jackson").build()).relocate(Relocation.builder().pattern("org{}snakeyaml{}engine").relocatedPattern("net.flectone.pulse.library.snakeyaml").build()).build());
        this.addLibrary(Library.builder().groupId("com{}zaxxer").artifactId("HikariCP").version("7.0.2").repository("https://repo1.maven.org/maven2/").relocate(Relocation.builder().pattern("com{}zaxxer{}hikari").relocatedPattern("net.flectone.pulse.library.hikari").build()).build());
        this.addLibrary(Library.builder().groupId("org{}jdbi").artifactId("jdbi3-core").version("3.49.6").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("org{}jdbi").relocatedPattern("net.flectone.pulse.library.jdbi3").build()).build());
        this.addLibrary(Library.builder().groupId("org{}jdbi").artifactId("jdbi3-sqlobject").version("3.49.6").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("org{}jdbi").relocatedPattern("net.flectone.pulse.library.jdbi3").build()).build());
        this.addLibrary(Library.builder().groupId("org{}apache{}commons").artifactId("commons-text").version("1.14.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("org{}apache{}commons").relocatedPattern("net.flectone.pulse.library.apache").build()).build());
    }

    @Generated
    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }
}

