/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ReflectionResolver {
    private final LibraryResolver libraryResolver;
    private final boolean paper;

    @Inject
    public ReflectionResolver(LibraryResolver libraryResolver) {
        this.libraryResolver = libraryResolver;
        this.paper = this.hasClass("com.destroystokyo.paper.ParticleBuilder");
    }

    public boolean hasClass(String className) {
        return this.resolveClass(className) != null;
    }

    public void hasClassOrElse(String className, Consumer<LibraryResolver> libraryConsumer) {
        boolean isAvailable = this.hasClass(className);
        if (!isAvailable) {
            libraryConsumer.accept(this.libraryResolver);
        }
    }

    @Nullable
    public Class<?> resolveClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean hasMethod(@NotNull Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return this.resolveMethod(clazz, methodName, parameterTypes) != null;
    }

    @Nullable
    public Method resolveMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            while (clazz != null) {
                try {
                    return clazz.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException ignored) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }
    }

    @Nullable
    public MethodHandle unreflectMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        return this.unreflectMethod(this.resolveMethod(clazz, methodName, parameterTypes));
    }

    @Nullable
    public MethodHandle unreflectMethod(@Nullable Method method) {
        if (method == null) {
            return null;
        }
        return this.unreflect(lookup -> lookup.unreflect(method));
    }

    @Nullable
    public MethodHandle unreflect(HandleFunction<MethodHandles.Lookup, MethodHandle> handleFunction) {
        try {
            return handleFunction.apply(MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Generated
    public boolean isPaper() {
        return this.paper;
    }

    @FunctionalInterface
    public static interface HandleFunction<T, R> {
        public R apply(T var1) throws IllegalAccessException;
    }
}

