/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.User;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.jetbrains.annotations.NotNull;

@Singleton
public class SkinService {
    @Named(value="profileProperty")
    private final Cache<UUID, PlayerHeadObjectContents.ProfileProperty> profilePropertyCache;
    private final FileResolver fileResolver;
    private final IntegrationModule integrationModule;
    private final PacketProvider packetProvider;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    public void updateProfilePropertyCache(UUID uuid, PlayerHeadObjectContents.ProfileProperty profileProperty) {
        this.profilePropertyCache.put((Object)uuid, (Object)profileProperty);
    }

    @NotNull
    public PlayerHeadObjectContents.ProfileProperty getProfilePropertyFromCache(FEntity entity) {
        FPlayer fPlayer;
        PlayerHeadObjectContents.ProfileProperty profileProperty = (PlayerHeadObjectContents.ProfileProperty)this.profilePropertyCache.getIfPresent((Object)entity.getUuid());
        if (profileProperty != null) {
            return profileProperty;
        }
        profileProperty = this.getProfileProperty(entity);
        if (entity instanceof FPlayer && !this.platformPlayerAdapter.isOnline(fPlayer = (FPlayer)entity) && profileProperty.signature() == null) {
            return profileProperty;
        }
        this.profilePropertyCache.put((Object)entity.getUuid(), (Object)profileProperty);
        return profileProperty;
    }

    @NotNull
    public PlayerHeadObjectContents.ProfileProperty getProfileProperty(FEntity entity) {
        List textureProperties;
        PlayerHeadObjectContents.ProfileProperty profileProperty = this.integrationModule.getProfileProperty(entity);
        if (profileProperty != null) {
            return profileProperty;
        }
        profileProperty = this.platformPlayerAdapter.getTexture(entity.getUuid());
        if (profileProperty != null) {
            return profileProperty;
        }
        User user = this.packetProvider.getUser(entity.getUuid());
        if (user != null && !(textureProperties = user.getProfile().getTextureProperties()).isEmpty()) {
            TextureProperty textureProperty = (TextureProperty)textureProperties.getFirst();
            return PlayerHeadObjectContents.property((String)"textures", (String)textureProperty.getValue(), (String)textureProperty.getSignature());
        }
        return PlayerHeadObjectContents.property((String)entity.getName(), (String)"");
    }

    public String getAvatarUrl(FEntity entity) {
        return Strings.CS.replace(this.fileResolver.getIntegration().getAvatarApiUrl(), "<skin>", this.getSkin(entity));
    }

    public String getBodyUrl(FEntity entity) {
        return Strings.CS.replace(this.fileResolver.getIntegration().getBodyApiUrl(), "<skin>", this.getSkin(entity));
    }

    public String getSkin(FEntity entity) {
        String texture = this.integrationModule.getTextureUrl(entity);
        return texture != null ? texture : entity.getUuid().toString();
    }

    @Inject
    @Generated
    public SkinService(@Named(value="profileProperty") Cache<UUID, PlayerHeadObjectContents.ProfileProperty> profilePropertyCache, FileResolver fileResolver, IntegrationModule integrationModule, PacketProvider packetProvider, PlatformPlayerAdapter platformPlayerAdapter) {
        this.profilePropertyCache = profilePropertyCache;
        this.fileResolver = fileResolver;
        this.integrationModule = integrationModule;
        this.packetProvider = packetProvider;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }
}

