/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.checker;

import lombok.Generated;
import net.flectone.pulse.FabricFlectonePulse;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FabricIntegrationModule;
import net.flectone.pulse.platform.adapter.FabricPlayerAdapter;
import net.flectone.pulse.platform.registry.FabricPermissionRegistry;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@Singleton
public class FabricPermissionChecker
implements PermissionChecker {
    private final FabricFlectonePulse fabricFlectonePulse;
    private final FabricIntegrationModule integrationModule;
    private final FabricPlayerAdapter fabricPlayerAdapter;
    private final FabricPermissionRegistry fabricPermissionRegistry;

    @Override
    public boolean check(FEntity entity, String permission) {
        FPlayer fPlayer;
        if (permission == null) {
            return true;
        }
        if (!(entity instanceof FPlayer) || (fPlayer = (FPlayer)entity).isUnknown()) {
            return true;
        }
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return true;
        }
        int fabricPermission = this.fabricPermissionRegistry.getPermissions().getOrDefault(permission, minecraftServer.method_3798());
        boolean value = fabricPermission == 0;
        class_3222 player = this.fabricPlayerAdapter.getPlayer(entity.getUuid());
        if (player != null) {
            value = player.method_64475(fabricPermission) || player.method_64475(minecraftServer.method_3798());
        }
        return value || this.integrationModule.hasFPlayerPermission(fPlayer, permission);
    }

    @Override
    public boolean check(FEntity entity, Permission.IPermission permission) {
        return permission == null || this.check(entity, permission.getName());
    }

    @Inject
    @Generated
    public FabricPermissionChecker(FabricFlectonePulse fabricFlectonePulse, FabricIntegrationModule integrationModule, FabricPlayerAdapter fabricPlayerAdapter, FabricPermissionRegistry fabricPermissionRegistry) {
        this.fabricFlectonePulse = fabricFlectonePulse;
        this.integrationModule = integrationModule;
        this.fabricPlayerAdapter = fabricPlayerAdapter;
        this.fabricPermissionRegistry = fabricPermissionRegistry;
    }
}

