/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.logging;

import io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.logging.LogFilter;
import net.kyori.adventure.text.Component;

@Singleton
public class FLogger
extends Logger {
    private final Consumer<LogRecord> logConsumer;
    private final LogFilter logFilter = new LogFilter();
    private FileResolver fileResolver;

    public FLogger(Consumer<LogRecord> logConsumer) {
        super("", null);
        this.logConsumer = logConsumer;
    }

    public FLogger(Logger logger) {
        super("", null);
        logger.setLevel(Level.OFF);
        this.setParent(logger);
        this.setLevel(Level.ALL);
        this.logConsumer = x$0 -> super.log((LogRecord)x$0);
    }

    public Config.Logger config() {
        return this.fileResolver == null ? null : this.fileResolver.getConfig().getLogger();
    }

    public void setupFilter() {
        this.logFilter.setFilters(this.config() == null ? Collections.emptyList() : this.config().getFilter());
    }

    @Override
    public void log(LogRecord logRecord) {
        if (this.config() == null) {
            logRecord.setLoggerName("FlectonePulse");
            this.logConsumer.accept(logRecord);
            return;
        }
        String prefix = this.config().getPrefix();
        String color = switch (logRecord.getLevel().intValue()) {
            case 900 -> this.config().getWarn();
            case 800 -> this.config().getInfo();
            default -> "";
        };
        logRecord.setLoggerName("");
        logRecord.setMessage(prefix + color + logRecord.getMessage() + "\u001b[0m");
        this.logConsumer.accept(logRecord);
    }

    @Override
    public void info(String msg) {
        LogRecord logRecord = new LogRecord(Level.INFO, msg);
        this.log(logRecord);
    }

    public void logEnabling() {
        this.info("Enabling...");
    }

    public void logEnabled() {
        this.info("FlectonePulse v1.6.1 enabled");
    }

    public void logDisabling() {
        this.info("Disabling...");
    }

    public void logDisabled() {
        this.info("FlectonePulse v1.6.1 disabled");
    }

    public void logReloading() {
        this.info("Reloading...");
    }

    public void logReloaded() {
        this.info("FlectonePulse v1.6.1 reloaded");
    }

    public void logDescription() {
        Config.Logger config = this.config();
        if (config == null) {
            return;
        }
        config.getDescription().forEach(string -> {
            string = string.replace("<version>", "1.6.1");
            this.info((String)string);
        });
    }

    @Override
    public void warning(String exception) {
        LogRecord logRecord = new LogRecord(Level.WARNING, exception);
        this.log(logRecord);
    }

    public void warning(String exception, Throwable throwable) {
        LogRecord logRecord = new LogRecord(Level.WARNING, exception);
        logRecord.setThrown(throwable);
        throwable.printStackTrace();
        this.log(logRecord);
    }

    public void warning(Throwable throwable) {
        this.warning("An error occurred, report it to https://github.com/Flectone/FlectonePulse/issues", throwable);
    }

    public void warningTree(Component component) {
        String json = (String)GsonComponentSerializer.gson().serialize(component);
        this.warning(json);
    }

    @Generated
    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }
}

