/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.misc.CodeHelpers;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\r\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/yukkuric/hexparse/commands/CommandConflictResolver;", "", "<init>", "()V", "", "init", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "ctx", "", "listAll", "(Lcom/mojang/brigadier/context/CommandContext;)I", "listName", "redirectName", "hexParse-common"})
public final class CommandConflictResolver {
    @NotNull
    public static final CommandConflictResolver INSTANCE = new CommandConflictResolver();

    private CommandConflictResolver() {
    }

    public final void init() {
        LiteralArgumentBuilder subCmd = (LiteralArgumentBuilder)class_2170.method_9247((String)"conflict").requires(CommandConflictResolver::init$lambda$0);
        LiteralArgumentBuilder[] literalArgumentBuilderArray = new LiteralArgumentBuilder[]{subCmd};
        HexParseCommands.registerLine(this::listAll, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
        literalArgumentBuilderArray = new LiteralArgumentBuilder[]{subCmd, class_2170.method_9247((String)"list")};
        HexParseCommands.registerLine(this::listAll, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
        literalArgumentBuilderArray = new ArgumentBuilder[]{subCmd, class_2170.method_9247((String)"list"), class_2170.method_9244((String)"name", (ArgumentType)((ArgumentType)class_2232.method_9441()))};
        HexParseCommands.registerLine(this::listName, (ArgumentBuilder[])literalArgumentBuilderArray);
        literalArgumentBuilderArray = new ArgumentBuilder[]{subCmd, class_2170.method_9247((String)"set"), class_2170.method_9244((String)"name", (ArgumentType)((ArgumentType)class_2232.method_9441())), class_2170.method_9244((String)"id", (ArgumentType)((ArgumentType)class_2232.method_9441()))};
        HexParseCommands.registerLine(this::redirectName, (ArgumentBuilder[])literalArgumentBuilderArray);
    }

    private final int listAll(CommandContext<class_2168> ctx) {
        CodeHelpers.autoRefresh(((class_2168)ctx.getSource()).method_9211());
        Set<String> set = PatternMapper.ShortNameTracker.shortNameWithConflicts;
        Intrinsics.checkNotNullExpressionValue(set, (String)"shortNameWithConflicts");
        List targets = CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)set));
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43471((String)"hexparse.cmd.conflict.list_all.title"));
        for (String name : targets) {
            Object[] objectArray = new Object[2];
            class_5250 class_52502 = class_2561.method_43470((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            objectArray[0] = HexUtils.getAqua((class_5250)class_52502);
            Set<class_2960> set2 = PatternMapper.ShortNameTracker.allPointed.get(name);
            objectArray[1] = set2 != null ? set2.size() : 0;
            class_5250 msg = class_2561.method_43469((String)"hexparse.cmd.conflict.list_all.entry", (Object[])objectArray);
            ((class_2168)ctx.getSource()).method_45068((class_2561)CodeHelpers.wrapClickSuggest(msg, "/hexParse conflict list " + name));
        }
        return targets.size();
    }

    private final int listName(CommandContext<class_2168> ctx) {
        CodeHelpers.autoRefresh(((class_2168)ctx.getSource()).method_9211());
        String name = class_2232.method_9443(ctx, (String)"name").method_12832();
        class_2960 curTarget = PatternMapper.ShortNameTracker.mapActiveShortName.get(name);
        if (curTarget == null) {
            class_2168 class_21682 = (class_2168)ctx.getSource();
            class_5250 class_52502 = class_2561.method_43471((String)"hexparse.cmd.conflict.error.name");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            class_21682.method_9213((class_2561)HexUtils.getDarkRed((class_5250)class_52502));
            return -1;
        }
        class_2168 class_21683 = (class_2168)ctx.getSource();
        Object[] objectArray = new Object[2];
        class_5250 class_52503 = class_2561.method_43470((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        objectArray[0] = HexUtils.getAqua((class_5250)class_52503);
        class_5250 class_52504 = class_2561.method_43470((String)curTarget.toString());
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
        objectArray[1] = HexUtils.getGold((class_5250)class_52504);
        class_21683.method_45068((class_2561)class_2561.method_43469((String)"hexparse.cmd.conflict.list.title", (Object[])objectArray));
        Collection<Object> collection = PatternMapper.ShortNameTracker.allPointed.get(name);
        if (collection == null || (collection = CollectionsKt.sorted((Iterable)collection)) == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection<Object> allEntries = collection;
        for (class_2960 class_29602 : allEntries) {
            Object[] objectArray2 = new Object[2];
            class_5250 class_52505 = class_2561.method_43470((String)class_29602.toString());
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"literal(...)");
            objectArray2[0] = HexUtils.getGold((class_5250)class_52505);
            objectArray2[1] = CodeHelpers.getPatternDisplay(class_29602, ((class_2168)ctx.getSource()).method_9225());
            class_5250 msg = class_2561.method_43469((String)"hexparse.cmd.conflict.list.entry", (Object[])objectArray2);
            ((class_2168)ctx.getSource()).method_45068((class_2561)CodeHelpers.wrapClickSuggest(msg, "/hexParse conflict set " + name + " " + class_29602));
        }
        return allEntries.size();
    }

    private final int redirectName(CommandContext<class_2168> ctx) {
        CodeHelpers.autoRefresh(((class_2168)ctx.getSource()).method_9211());
        String name = class_2232.method_9443(ctx, (String)"name").method_12832();
        class_2960 id = class_2232.method_9443(ctx, (String)"id");
        PatternMapper.ShortNameTracker.redirectShortName(name, id);
        class_2168 class_21682 = (class_2168)ctx.getSource();
        Object[] objectArray = new Object[3];
        class_5250 class_52502 = class_2561.method_43470((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        objectArray[0] = HexUtils.getAqua((class_5250)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)id.toString());
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        objectArray[1] = HexUtils.getGold((class_5250)class_52503);
        objectArray[2] = CodeHelpers.getPatternDisplay(id, ((class_2168)ctx.getSource()).method_9225());
        class_21682.method_45068((class_2561)class_2561.method_43469((String)"hexparse.cmd.conflict.edited", (Object[])objectArray));
        return 1;
    }

    private static final boolean init$lambda$0(class_2168 s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (HexParse.HELPERS.isPhysicalClient()) {
            return true;
        }
        return s.method_9259(2);
    }
}

