/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.misc.CodeHelpers;
import java.util.ArrayList;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public class CommandLehmerHelper {
    static final int MAX_COUNT = 20;

    public static void init() {
        HexParseCommands.registerLine(CommandLehmerHelper::CalcLehmer, (ArgumentBuilder[])new ArgumentBuilder[]{class_2170.method_9247((String)"lehmer"), class_2170.method_9244((String)"input", (ArgumentType)StringArgumentType.greedyString())});
    }

    public static int CalcLehmer(CommandContext<class_2168> ctx) {
        String[] raw = StringArgumentType.getString(ctx, (String)"input").split("\\s");
        ArrayList<Integer> orders = new ArrayList<Integer>();
        for (String seg : raw) {
            try {
                Integer num = Integer.valueOf(seg);
                orders.add(num);
                if (orders.size() <= 20) continue;
                throw new IndexOutOfBoundsException(HexParse.doTranslate("hexparse.msg.error.code_too_long", 20));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.unknown_symbol", seg));
            }
        }
        long res = 0L;
        long frac = 1L;
        for (int offset = 1; offset < orders.size(); ++offset) {
            frac *= (long)offset;
            int pos = orders.size() - 1 - offset;
            int cur = (Integer)orders.get(pos);
            int cnt = 0;
            for (int j = pos; j < orders.size(); ++j) {
                if ((Integer)orders.get(j) >= cur) continue;
                ++cnt;
            }
            res += frac * (long)cnt;
        }
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player != null) {
            String resStr = String.valueOf(res);
            CodeHelpers.displayCode(player, resStr);
        }
        return 1;
    }
}

