/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001b\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\f\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001b\u0010\r\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\r\u0010\u000bJ\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/yukkuric/hexparse/commands/CommandMindStackIO;", "", "<init>", "()V", "", "init", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "ctx", "", "pullClipboard", "(Lcom/mojang/brigadier/context/CommandContext;)I", "readStack", "writeStack", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_2487;", "iotaTag", "writeStackWithIota", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2487;)V", "hexParse-common"})
public final class CommandMindStackIO {
    @NotNull
    public static final CommandMindStackIO INSTANCE = new CommandMindStackIO();

    private CommandMindStackIO() {
    }

    public final void init() {
        LiteralArgumentBuilder[] literalArgumentBuilderArray = new LiteralArgumentBuilder[]{class_2170.method_9247((String)"mind_stack"), class_2170.method_9247((String)"peek")};
        LiteralArgumentBuilder subCmd = (LiteralArgumentBuilder)HexParseCommands.registerLine(this::readStack, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
        literalArgumentBuilderArray = new ArgumentBuilder[]{subCmd, class_2170.method_9247((String)"push"), class_2170.method_9244((String)"code", (ArgumentType)((ArgumentType)StringArgumentType.string()))};
        HexParseCommands.registerLine(this::writeStack, (ArgumentBuilder[])literalArgumentBuilderArray);
        literalArgumentBuilderArray = new LiteralArgumentBuilder[]{subCmd, class_2170.method_9247((String)"push_clipboard")};
        HexParseCommands.registerLine(this::pullClipboard, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
    }

    public final int readStack(@NotNull CommandContext<class_2168> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        CastingHarness img = IXplatAbstractions.INSTANCE.getHarness(player, class_1268.field_5808);
        List stack = img.getStack();
        Iota lastIota = stack.isEmpty() ? (Iota)new NullIota() : (Iota)stack.get(stack.size() - 1);
        String code = ParserMain.ParseIotaNbt(HexIotaTypes.serialize((Iota)lastIota), player, StringProcessors.READ_DEFAULT);
        CodeHelpers.displayCode(player, code);
        return 1;
    }

    public final int writeStack(@NotNull CommandContext<class_2168> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        String code = StringArgumentType.getString(ctx, (String)"code");
        class_2487 nbt = ParserMain.ParseCode(code, ((class_2168)ctx.getSource()).method_44023());
        class_3222 class_32222 = ((class_2168)ctx.getSource()).method_44023();
        Intrinsics.checkNotNull((Object)class_32222);
        Intrinsics.checkNotNull((Object)nbt);
        this.writeStackWithIota(class_32222, nbt);
        return 1;
    }

    public final int pullClipboard(@NotNull CommandContext<class_2168> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        MsgHandlers.SERVER.sendPacketToPlayer(((class_2168)ctx.getSource()).method_44023(), new MsgPullClipboard(null, ClipboardMsgMode.PUSH_MIND));
        return 1;
    }

    public final void writeStackWithIota(@NotNull class_3222 player, @NotNull class_2487 iotaTag) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)iotaTag, (String)"iotaTag");
        Iota newIota = HexIotaTypes.deserialize((class_2487)iotaTag, (class_3218)player.method_14220());
        CastingHarness img = IXplatAbstractions.INSTANCE.getHarness(player, class_1268.field_5808);
        List stack = img.getStack();
        Intrinsics.checkNotNull((Object)newIota);
        stack.add(newIota);
        IXplatAbstractions.INSTANCE.setHarness(player, img);
    }
}

