/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.function.BiConsumer;
import miyucomics.hexcellular.StateStorage;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class CommandPropertyIO {
    public static void init() {
        ArgumentBuilder sub_property = HexParseCommands.registerLine(ctx -> CommandPropertyIO.propertyOp((CommandContext<class_2168>)ctx, CommandPropertyIO::readProp), (ArgumentBuilder[])new ArgumentBuilder[]{class_2170.method_9247((String)"property"), class_2170.method_9247((String)"read"), class_2170.method_9244((String)"propName", (ArgumentType)StringArgumentType.string())});
        HexParseCommands.registerLine(ctx -> CommandPropertyIO.propertyOp((CommandContext<class_2168>)ctx, CommandPropertyIO::writeProp), (ArgumentBuilder[])new ArgumentBuilder[]{sub_property, class_2170.method_9247((String)"write"), class_2170.method_9244((String)"propName", (ArgumentType)StringArgumentType.string()), class_2170.method_9244((String)"code", (ArgumentType)StringArgumentType.string())});
        HexParseCommands.registerLine(ctx -> CommandPropertyIO.propertyOp((CommandContext<class_2168>)ctx, CommandPropertyIO::pullClipboard), (ArgumentBuilder[])new ArgumentBuilder[]{sub_property, class_2170.method_9247((String)"clipboard"), class_2170.method_9244((String)"propName", (ArgumentType)StringArgumentType.string())});
    }

    static int propertyOp(CommandContext<class_2168> ctx, @NotNull BiConsumer<String, CommandContext<class_2168>> action) {
        String propName = StringArgumentType.getString(ctx, (String)"propName");
        propName = (String)StringProcessors.APPEND_UNDERLINE.apply(propName);
        action.accept(propName, ctx);
        return 1;
    }

    static void readProp(String propName, CommandContext<class_2168> ctx) {
        Iota data = StateStorage.Companion.getProperty(((class_2168)ctx.getSource()).method_9225(), propName);
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        String code = ParserMain.ParseIotaNbt(HexIotaTypes.serialize((Iota)data), player, StringProcessors.READ_DEFAULT);
        CodeHelpers.displayCode(player, code);
    }

    static void writeProp(String propName, CommandContext<class_2168> ctx) {
        String code = StringArgumentType.getString(ctx, (String)"code");
        class_2487 nbt = ParserMain.ParseCode(code, ((class_2168)ctx.getSource()).method_44023());
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        StateStorage.Companion.setProperty(world, propName, HexIotaTypes.deserialize((class_2487)nbt, (class_3218)world));
    }

    static void pullClipboard(String propName, CommandContext<class_2168> ctx) {
        MsgHandlers.SERVER.sendPacketToPlayer(((class_2168)ctx.getSource()).method_44023(), new MsgPullClipboard(propName, ClipboardMsgMode.WRITE_PROPERTY));
    }
}

