/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.fabric;

import at.petrak.hexcasting.common.network.IMessage;
import com.mojang.brigadier.CommandDispatcher;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.IModHelpers;
import io.yukkuric.hexparse.fabric.config.HexParseConfigFabric;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.network.ISenderServer;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPushClipboard;
import io.yukkuric.hexparse.network.macro.MsgPushMacro;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class HexParseFabric
implements ModInitializer {
    static Network NETWORK;
    static ModHelpers HELPERS;

    public void onInitialize() {
        NETWORK = new Network();
        HELPERS = new ModHelpers();
        HexParse.init();
        HexParseConfigFabric.setup();
        CommandRegistrationCallback.EVENT.register((dp, foo, bar) -> HexParseCommands.register((CommandDispatcher<class_2168>)dp));
    }

    public static void markPhysicalClient() {
        ModHelpers.markClient = true;
    }

    static class Network
    implements ISenderServer {
        static <T> ServerPlayNetworking.PlayChannelHandler makeServerBoundHandler(Function<class_2540, T> decoder, BiConsumer<T, class_3222> handle) {
            return (server, player, _handler, buf, _responseSender) -> handle.accept(decoder.apply(buf), player);
        }

        Network() {
            MsgHandlers.SERVER = this;
            ServerPlayNetworking.registerGlobalReceiver((class_2960)MsgPushClipboard.ID, (ServerPlayNetworking.PlayChannelHandler)Network.makeServerBoundHandler(MsgPushClipboard::deserialize, MsgPushClipboard::handle));
            ServerPlayNetworking.registerGlobalReceiver((class_2960)MsgPushMacro.ID, (ServerPlayNetworking.PlayChannelHandler)Network.makeServerBoundHandler(MsgPushMacro::deserialize, MsgPushMacro::handle));
        }

        @Override
        public void sendPacketToPlayer(class_3222 player, IMessage packet) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getFabricId(), (class_2540)packet.toBuf());
        }
    }

    static class ModHelpers
    implements IModHelpers {
        static boolean markClient = false;

        ModHelpers() {
            HexParse.HELPERS = this;
        }

        @Override
        public boolean modLoaded(String modId) {
            return FabricLoader.getInstance().isModLoaded(modId);
        }

        @Override
        public boolean isPhysicalClient() {
            return markClient;
        }
    }
}

