/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.math.HexDir;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.CommentIotaType;
import io.yukkuric.hexparse.parsers.IotaFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3544;
import org.jetbrains.annotations.NotNull;

public class PatternMapper {
    static final ConcurrentMap<String, Object> staticMapper;
    public static final ConcurrentMap<class_2960, Object> greatMapper;
    static final Method m_opId;
    static final Method m_preferredStart;
    public static final Map<String, class_2487> mapPattern;
    public static final Map<String, class_2487> mapPatternWorld;

    static void _setMap(Map<String, class_2487> map, class_2960 id, String seq, HexDir dir) {
        String idLong = id.toString();
        String idShort = id.method_12832();
        class_2487 pattern = IotaFactory.makePattern(seq, dir);
        map.put(idLong, pattern);
        if (ShortNameTracker.recordNewShortName(id)) {
            map.put(idShort, pattern);
        }
    }

    public static void init(class_3218 level) {
        ShortNameTracker.clear(level);
        level.method_8503().method_30002().method_17983().method_123("hex.per-world-patterns", (class_18)PatternRegistry.Save.create((long)level.method_8412()));
        try {
            HexDir dir;
            class_2960 id;
            Object entry;
            String seq;
            for (Map.Entry pair : staticMapper.entrySet()) {
                seq = (String)pair.getKey();
                entry = pair.getValue();
                id = (class_2960)m_opId.invoke(entry, new Object[0]);
                dir = (HexDir)m_preferredStart.invoke(entry, new Object[0]);
                PatternMapper._setMap(mapPattern, id, seq, dir);
            }
            for (Map.Entry pair : PatternRegistry.getPerWorldPatterns((class_3218)level).entrySet()) {
                seq = (String)pair.getKey();
                entry = (Pair)pair.getValue();
                id = (class_2960)entry.getFirst();
                dir = (HexDir)entry.getSecond();
                PatternMapper._setMap(mapPatternWorld, id, seq, dir);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void initLocal() {
        try {
            for (Map.Entry pair : staticMapper.entrySet()) {
                String seq = (String)pair.getKey();
                Object entry = pair.getValue();
                class_2960 id = (class_2960)m_opId.invoke(entry, new Object[0]);
                HexDir dir = (HexDir)m_preferredStart.invoke(entry, new Object[0]);
                PatternMapper._setMap(mapPattern, id, seq, dir);
            }
            String fooSeq = CommentIotaType.COMMENT_PATTERN.anglesSignature();
            for (class_2960 id : greatMapper.keySet()) {
                PatternMapper._setMap(mapPatternWorld, id, fooSeq, HexDir.EAST);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapPattern = new HashMap<String, class_2487>();
        mapPatternWorld = new HashMap<String, class_2487>();
        try {
            Field fStaticMapper = PatternRegistry.class.getDeclaredField("regularPatternLookup");
            fStaticMapper.setAccessible(true);
            staticMapper = (ConcurrentMap)fStaticMapper.get(null);
            fStaticMapper = PatternRegistry.class.getDeclaredField("perWorldPatternLookup");
            fStaticMapper.setAccessible(true);
            greatMapper = (ConcurrentMap)fStaticMapper.get(null);
            Class<?> clsRegularEntry = Class.forName("at.petrak.hexcasting.api.PatternRegistry$RegularEntry");
            m_opId = clsRegularEntry.getMethod("opId", new Class[0]);
            m_opId.setAccessible(true);
            m_preferredStart = clsRegularEntry.getMethod("preferredStart", new Class[0]);
            m_preferredStart.setAccessible(true);
            mapPattern.put("\\", IotaFactory.makePattern("qqqaw", HexDir.WEST));
            mapPattern.put("(", IotaFactory.makePattern("qqq", HexDir.WEST));
            mapPattern.put(")", IotaFactory.makePattern("eee", HexDir.EAST));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ShortNameTracker {
        public static final Map<String, class_2487>[] modifyTargets = new Map[]{mapPattern, mapPatternWorld};
        public static final Map<String, Set<class_2960>> allPointed = new HashMap<String, Set<class_2960>>();
        public static final Map<String, class_2960> mapActiveShortName = new HashMap<String, class_2960>();
        public static final Set<String> shortNameWithConflicts = new HashSet<String>();
        private static ShortNameTrackerPersistent manualTargets;

        static boolean recordNewShortName(class_2960 id) {
            boolean imBoss;
            String shortName = id.method_12832();
            String longName = id.toString();
            Set locList = allPointed.computeIfAbsent(shortName, k -> new HashSet());
            locList.add(id);
            if (locList.size() > 1) {
                shortNameWithConflicts.add(shortName);
            }
            class_2960 idExist = mapActiveShortName.get(shortName);
            boolean manualSelected = false;
            boolean manualOld = false;
            if (manualTargets != null) {
                String selectedLong = manualTargets.get(shortName);
                manualSelected = longName.equals(selectedLong);
                manualOld = !class_3544.method_15438((String)selectedLong);
            }
            boolean bl = imBoss = manualSelected || !manualOld && id.method_12836().equals("hexcasting");
            if (idExist == null || imBoss) {
                mapActiveShortName.put(shortName, id);
                return true;
            }
            return false;
        }

        static void clear(class_3218 level) {
            allPointed.clear();
            mapActiveShortName.clear();
            shortNameWithConflicts.clear();
            manualTargets = ShortNameTrackerPersistent.get(level);
        }

        public static String getActiveLongName(String shortName) {
            class_2960 id = mapActiveShortName.get(shortName);
            return id == null ? shortName : id.toString();
        }

        public static void redirectShortName(String shortName, class_2960 newId) {
            Set<class_2960> validIdSet = allPointed.get(shortName);
            if (validIdSet == null || !shortNameWithConflicts.contains(shortName)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.name", new Object[0])));
            }
            if (!validIdSet.contains(newId)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.id", newId)));
            }
            String longName = newId.toString();
            boolean found = false;
            for (Map<String, class_2487> map : modifyTargets) {
                class_2487 tryLongEntry;
                map.remove(shortName);
                if (found || (tryLongEntry = map.get(longName)) == null) continue;
                found = true;
                map.put(shortName, tryLongEntry);
            }
            if (!found) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, "excuse me WTF?"));
            }
            mapActiveShortName.put(shortName, newId);
            if (manualTargets != null) {
                manualTargets.put(shortName, longName);
            }
        }
    }

    private static class ShortNameTrackerPersistent
    extends class_18 {
        static final String SAVENAME = "hexparse.short_name.settings";
        static final class_2487 settings = new class_2487();

        ShortNameTrackerPersistent() {
        }

        ShortNameTrackerPersistent(class_2487 load) {
            settings.method_10543(load);
        }

        static ShortNameTrackerPersistent get(class_3218 level) {
            class_26 ds = level.method_17983();
            return (ShortNameTrackerPersistent)ds.method_17924(ShortNameTrackerPersistent::new, ShortNameTrackerPersistent::new, SAVENAME);
        }

        @NotNull
        public class_2487 method_75(class_2487 body) {
            body.method_10543(settings);
            return body;
        }

        public String get(String shortName) {
            return settings.method_10558(shortName);
        }

        public void put(String shortName, String longName) {
            settings.method_10582(shortName, longName);
        }
    }
}

