/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.misc;

import java.util.function.Function;

public class StringProcessors {
    public static F OMIT_MC = StringProcessors.omitPrefix("minecraft:");
    public static F OMIT_HEX = StringProcessors.omitPrefix("hexcasting:");
    public static F APPEND_UNDERLINE = StringProcessors.appendPrefix("_");
    public static F READ_DEFAULT = res -> res.replaceAll("(?<=\\[|]|\\(|\\)|^|\\n|\\s),|,(?=\\[|]|\\(|\\)|$|\\n)", "");
    public static F READ_HEXBOT_VARIANT = new ChainedF(s -> s.replace("\\", "consideration"), s -> s.replace('(', '{').replace(')', '}'), s -> s.replaceAll("mask_", "mask "), s -> s.replaceAll("num_", "number "), s -> s.replaceAll("comment_.*?(?=,|$)", ""), s -> s.replaceAll("\\n\\s*", ","), s -> s.replaceAll("[a-z_]+:", ""), s -> s.replaceAll(",(?=,)", ""), s -> s.replace("eval/cc", "NORTH_WEST qwaqde"));

    public static F omitPrefix(String prefix) {
        return s -> s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static F appendPrefix(String prefix) {
        return s -> s.startsWith(prefix) ? s : prefix + s;
    }

    public static interface F
    extends Function<String, String> {
    }

    public static class ChainedF
    implements F {
        final F inner;
        ChainedF chained = null;
        ChainedF tail = this;

        public ChainedF(F func, F ... funcs) {
            this.inner = func;
            for (F f : funcs) {
                this.append(f);
            }
        }

        @Override
        public String apply(String s) {
            String res = (String)this.inner.apply(s);
            if (this.chained != null) {
                res = this.chained.apply(res);
            }
            return res;
        }

        public ChainedF append(F next) {
            ChainedF n1;
            ChainedF node;
            this.tail.chained = node = next instanceof ChainedF ? (n1 = (ChainedF)next) : new ChainedF(next, new F[0]);
            this.tail = node;
            return this;
        }
    }
}

