/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.network;

import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import io.yukkuric.hexparse.commands.CommandMindStackIO;
import io.yukkuric.hexparse.macro.MacroManager;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHelpers;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.ArrayList;
import java.util.List;
import miyucomics.hexcellular.StateStorage;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public record MsgPushClipboard(List<String> code, String rename, ClipboardMsgMode mode) implements IMessage
{
    public static final class_2960 ID = new class_2960("hexparse", "clipboard/push");

    public void serialize(class_2540 buf) {
        buf.writeInt(this.code.size());
        for (String f : this.code) {
            MsgHelpers.putString(buf, f);
        }
        MsgHelpers.putString(buf, this.rename);
        buf.writeByte(this.mode.ordinal());
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public static MsgPushClipboard deserialize(ByteBuf buffer) {
        ClipboardMsgMode mode;
        class_2540 buf = new class_2540(buffer);
        ArrayList<String> code = new ArrayList<String>();
        int len = buf.readInt();
        for (int i = 0; i < len; ++i) {
            code.add(MsgHelpers.getString(buf));
        }
        String name = MsgHelpers.getString(buf);
        try {
            mode = ClipboardMsgMode.values()[buf.readByte()];
        }
        catch (IndexOutOfBoundsException e) {
            mode = ClipboardMsgMode.DEFAULT;
        }
        catch (Throwable e) {
            mode = ClipboardMsgMode.INVALID;
        }
        return new MsgPushClipboard(code, name, mode);
    }

    public static void handle(MsgPushClipboard self, class_3222 sender) {
        if (self.mode == ClipboardMsgMode.INVALID) {
            return;
        }
        if (self.mode == ClipboardMsgMode.MACRO_DEFINE) {
            String macro = String.join((CharSequence)",", self.code);
            MacroManager.modifyMacro(sender, true, self.rename, macro);
        } else if (self.mode == ClipboardMsgMode.WRITE_PROPERTY) {
            class_2487 nbt = ParserMain.ParseCode(self.code, sender);
            class_3218 world = sender.method_14220();
            StateStorage.Companion.setProperty(world, self.rename, HexIotaTypes.deserialize((class_2487)nbt, (class_3218)world));
        } else if (self.mode == ClipboardMsgMode.PUSH_MIND) {
            class_2487 nbt = ParserMain.ParseCode(self.code, sender);
            CommandMindStackIO.INSTANCE.writeStackWithIota(sender, nbt);
        } else {
            CodeHelpers.doParse(sender, self.code, self.rename);
        }
    }
}

