/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IotaFactory;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class PluginIotaFactory
extends IotaFactory {
    public static final String TYPE_IOTA_TYPE = "hexal:iota_type";
    public static final String TYPE_ENTITY_TYPE = "hexal:entity_type";
    public static final String TYPE_ITEM_TYPE = "hexal:item_type";
    public static final String TYPE_STRING = "moreiotas:string";
    public static final String TYPE_MATRIX = "moreiotas:matrix";
    public static final String TYPE_GATE = "hexal:gate";
    public static final String TYPE_MOTE = "hexal:item";
    public static final String TYPE_PROP = "hexcellular:property";
    public static final String TYPE_RESLOC = "hexpose:identifier";

    public static class_2487 makeIotaType(String type) {
        return PluginIotaFactory.makeType(TYPE_IOTA_TYPE, (class_2520)class_2519.method_23256((String)type));
    }

    public static class_2487 makeEntityType(String type) {
        return PluginIotaFactory.makeType(TYPE_ENTITY_TYPE, (class_2520)class_2519.method_23256((String)type));
    }

    public static class_2487 makeItemType(String type, boolean isBlock) {
        class_2487 body = new class_2487();
        body.method_10582(isBlock ? "block" : "item", type);
        return PluginIotaFactory.makeType(TYPE_ITEM_TYPE, (class_2520)body);
    }

    public static class_2487 makeItemType(String type) {
        return PluginIotaFactory.makeItemType(type, false);
    }

    public static class_2487 makeBlockType(String type) {
        return PluginIotaFactory.makeItemType(type, true);
    }

    public static class_2487 makeString(String data) {
        return PluginIotaFactory.makeType(TYPE_STRING, (class_2520)class_2519.method_23256((String)data));
    }

    public static class_2487 makeMatrix(String[] raw) {
        int ncol;
        int nrow;
        class_2487 body = new class_2487();
        int ptr = 1;
        int targetSize = 3;
        if (raw.length < targetSize) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.data_amount", raw.length, targetSize));
        }
        try {
            nrow = Integer.parseInt(raw[ptr]);
            if (nrow <= 0) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.size", nrow));
            }
            body.method_10569("rows", nrow);
            ncol = Integer.parseInt(raw[++ptr]);
            if (ncol <= 0) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.size", ncol));
            }
            ++ptr;
            body.method_10569("cols", ncol);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.size", raw[ptr]));
        }
        targetSize = nrow * ncol;
        if (raw.length - 3 < targetSize) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.data_amount", raw.length - 3, targetSize));
        }
        class_2499 data = new class_2499();
        try {
            for (int i = 0; i < nrow; ++i) {
                class_2499 row = new class_2499();
                for (int j = 0; j < ncol; ++j) {
                    row.add((Object)class_2489.method_23241((double)Double.parseDouble(raw[ptr])));
                    ++ptr;
                }
                data.add((Object)row);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.value", raw[ptr]));
        }
        body.method_10566("mat", (class_2520)data);
        return PluginIotaFactory.makeType(TYPE_MATRIX, (class_2520)body);
    }

    public static class_2487 makeProperty(class_2487 packed) {
        return PluginIotaFactory.makeType(TYPE_PROP, (class_2520)packed);
    }

    public static class_2487 makeGate(int id, class_243 pos, class_1297 binder) {
        byte type = 0;
        if (binder != null) {
            type = 2;
            if (pos == null) {
                pos = class_243.field_1353;
            }
        } else if (pos != null) {
            type = 1;
        }
        class_2487 payload = new class_2487();
        payload.method_10569("index", id);
        payload.method_10567("target_type", type);
        if (pos != null) {
            payload.method_10549("target_x", pos.field_1352);
            payload.method_10549("target_y", pos.field_1351);
            payload.method_10549("target_z", pos.field_1350);
        }
        if (binder != null) {
            payload.method_25927("target_uuid", binder.method_5667());
            payload.method_10582("target_name", binder.method_5477().getString());
        }
        return PluginIotaFactory.makeType(TYPE_GATE, (class_2520)payload);
    }

    public static class_2487 makeResLoc(String raw) {
        class_2960 resloc = new class_2960(raw);
        class_2487 res = new class_2487();
        res.method_10582("path", resloc.method_12832());
        res.method_10582("namespace", resloc.method_12836());
        return PluginIotaFactory.makeType(TYPE_RESLOC, (class_2520)res);
    }
}

