/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.macro.MacroManager;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CommandMacro {
    public static void init() {
        CommandMacro.initWith((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"macro"), true);
        CommandMacro.initWith((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"dialect"), false);
    }

    static void initWith(LiteralArgumentBuilder<class_2168> sub, boolean isMacro) {
        HexParseCommands.registerLine(ctx -> {
            class_3222 self = ((class_2168)ctx.getSource()).method_44023();
            if (self == null) {
                return 0;
            }
            List<Pair<String, String>> entries = MacroManager.listMacros(self, isMacro);
            self.method_43496((class_2561)class_2561.method_43469((String)"hexparse.cmd.macro.list.title", (Object[])new Object[]{entries.size(), class_2561.method_43471((String)("hexparse.cmd.macro.list.title." + (isMacro ? "macro" : "dialect")))}));
            for (Pair<String, String> pair : entries) {
                self.method_43496((class_2561)class_2561.method_43469((String)"hexparse.cmd.macro.list.kv", (Object[])new Object[]{MacroManager.showGold((String)pair.first()), MacroManager.showGold((String)pair.second())}));
            }
            return entries.size();
        }, (ArgumentBuilder[])new LiteralArgumentBuilder[]{sub, class_2170.method_9247((String)"list")});
        BiFunction<CommandContext, Boolean, Integer> generalModify = (ctx, isDefine) -> {
            class_3222 self = ((class_2168)ctx.getSource()).method_44023();
            if (self == null) {
                return 0;
            }
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            if ((key = CommandMacro.wrapCheckMacroKey(self, key, isMacro)) == null) {
                return 0;
            }
            if (isDefine.booleanValue()) {
                if (MacroManager.willThisExceedLimit(self, key)) {
                    self.method_43496((class_2561)class_2561.method_43471((String)"hexparse.msg.error.macro.too_many.single").method_27692(class_124.field_1079));
                    return 0;
                }
                if (key.length() > 1024) {
                    self.method_43496((class_2561)class_2561.method_43471((String)"hexparse.msg.error.macro.too_long.key").method_27692(class_124.field_1079));
                    return 0;
                }
                String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
                if (value.length() > 1024) {
                    self.method_43496((class_2561)class_2561.method_43469((String)"hexparse.msg.error.macro.too_long", (Object[])new Object[]{value.length() - 1024}).method_27692(class_124.field_1065));
                    value = value.substring(0, 1024);
                }
                MacroManager.modifyMacro(self, true, key, value);
            } else {
                MacroManager.modifyMacro(self, false, key, null);
            }
            return 1;
        };
        HexParseCommands.registerLine(ctx -> (Integer)generalModify.apply(ctx, true), (ArgumentBuilder[])new ArgumentBuilder[]{sub, class_2170.method_9247((String)"define"), class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()), class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString())});
        HexParseCommands.registerLine(ctx -> (Integer)generalModify.apply(ctx, false), (ArgumentBuilder[])new ArgumentBuilder[]{sub, class_2170.method_9247((String)"remove"), class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string())});
        if (isMacro) {
            HexParseCommands.registerLine(ctx -> {
                class_3222 self = ((class_2168)ctx.getSource()).method_44023();
                if (self == null) {
                    return 0;
                }
                String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
                if ((key = CommandMacro.wrapCheckMacroKey(self, key, isMacro)) == null) {
                    return 0;
                }
                MsgHandlers.SERVER.sendPacketToPlayer(self, new MsgPullClipboard(key, ClipboardMsgMode.MACRO_DEFINE));
                return 1;
            }, (ArgumentBuilder[])new ArgumentBuilder[]{sub, class_2170.method_9247((String)"define_clipboard"), class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string())});
        }
    }

    static String wrapCheckMacroKey(class_3222 self, String key, boolean isMacro) {
        if (isMacro == MacroManager.isMacro(key)) {
            return key;
        }
        if (isMacro) {
            return "#" + key;
        }
        self.method_43496((class_2561)class_2561.method_43469((String)"hexparse.msg.error.invalid_dialect_key", (Object[])new Object[]{key}).method_27692(class_124.field_1079));
        return null;
    }
}

