/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.fabric.config;

import io.yukkuric.hexparse.config.HexParseConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="hexparse")
public class HexParseConfigFabric
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    private final Common common = new Common();

    public static void setup() {
        AutoConfig.register(HexParseConfigFabric.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        HexParseConfigFabric instance = (HexParseConfigFabric)AutoConfig.getConfigHolder(HexParseConfigFabric.class).getConfig();
        HexParseConfig.bindConfigImp(instance.common);
    }

    @Config(name="common")
    public static class Common
    implements HexParseConfig.API,
    ConfigData {
        @Comment(value="can directly parse great spell patterns, without scrolls")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private HexParseConfig.ParseGreatPatternMode parseGreatSpells = HexParseConfig.ParseGreatPatternMode.BY_SCROLL;
        @Comment(value="how comments get parsed into iotas\nALL: including `comment_%s`s and `/* */`s & `//`s;\nMANUAL(default): only `comment_%s`s;\nDISABLED: no comments at all")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private HexParseConfig.CommentParsingMode commentParsingMode = HexParseConfig.CommentParsingMode.MANUAL;
        @Comment(value="how indents get parsed into iotas\nALL(default): coding indents will be auto-converted into `tab_%d`;\nMANUAL: only `tab_%d`s accepted;\nDISABLED: no indents at all")
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        private HexParseConfig.CommentParsingMode indentParsingMode = HexParseConfig.CommentParsingMode.MANUAL;
        @Comment(value="cost to parse single keyword into iota")
        private int parserBaseCost = 0;
        @Comment(value="display colorful nested lists and intro/retros")
        private boolean showColorfulNested = true;
        @Comment(value="how to handle unsupported iota's inner data\nKEEP_NBT(default): save whole NBT as Base64 string;\nSHOW_NBT: output `UNKNOWN(serialized NBT)`;\nSIMPLE: show `UNKNOWN` only")
        private HexParseConfig.UnknownNbtHandlingMode showUnknownNBT = HexParseConfig.UnknownNbtHandlingMode.KEEP_NBT;
        @Comment(value="how many continuous blank lines are allowed in parsed spell; excess ones will be ignored")
        private int maxBlankLineCount = 0;

        @Override
        public HexParseConfig.ParseGreatPatternMode canParseGreatPatterns() {
            return this.parseGreatSpells;
        }

        @Override
        public HexParseConfig.CommentParsingMode getCommentParsingMode() {
            return this.commentParsingMode;
        }

        @Override
        public HexParseConfig.CommentParsingMode getIndentParsingMode() {
            return this.indentParsingMode;
        }

        @Override
        public int getMaxBlankLineCount() {
            return this.maxBlankLineCount;
        }

        @Override
        public boolean showColorfulNested() {
            return this.showColorfulNested;
        }

        @Override
        public HexParseConfig.UnknownNbtHandlingMode showUnknownNBT() {
            return this.showUnknownNBT;
        }

        @Override
        public int parserBaseCost() {
            return this.parserBaseCost;
        }
    }
}

