/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IotaFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_18;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3544;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

public class PatternMapper {
    public static final Map<String, class_2487> mapPatternMeta = new HashMap<String, class_2487>();
    public static final Map<String, class_2487> mapPattern = new HashMap<String, class_2487>();
    public static final Map<String, class_2487> mapPatternWorld = new HashMap<String, class_2487>();

    static void _setMap(Map<String, class_2487> map, class_2960 id, String seq, HexDir dir) {
        String idLong = id.toString();
        String idShort = id.method_12832();
        class_2487 pattern = IotaFactory.makePattern(seq, dir);
        map.put(idLong, pattern);
        if (ShortNameTracker.recordNewShortName(id)) {
            map.put(idShort, pattern);
        }
    }

    public static void init(class_3218 level) {
        mapPattern.clear();
        mapPatternWorld.clear();
        ShortNameTracker.clear(level);
        class_2378 registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        class_3218 overworld = level.method_8503().method_30002();
        class_26 ds = overworld.method_17983();
        ScrungledPatternsSave perWorldPatterns = ScrungledPatternsSave.createFromScratch((long)level.method_8412());
        ds.method_123("hexcasting.per-world-patterns.0.1.0", (class_18)perWorldPatterns);
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            if (HexUtils.isOfTag((class_2378)registry, (class_5321)key, (class_6862)HexTags.Actions.PER_WORLD_PATTERN)) {
                Pair perWorldEntry = perWorldPatterns.lookupReverse(key);
                if (perWorldEntry == null) continue;
                PatternMapper._setMap(mapPatternWorld, key.method_29177(), (String)perWorldEntry.getFirst(), ((ScrungledPatternsSave.PerWorldEntry)perWorldEntry.getSecond()).canonicalStartDir());
                continue;
            }
            HexPattern pattern = ((ActionRegistryEntry)entry.getValue()).prototype();
            PatternMapper._setMap(mapPattern, key.method_29177(), pattern.anglesSignature(), pattern.getStartDir());
        }
    }

    public static void initLocal() {
        class_2378 registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            Map<String, class_2487> mapper = HexUtils.isOfTag((class_2378)registry, (class_5321)key, (class_6862)HexTags.Actions.PER_WORLD_PATTERN) ? mapPatternWorld : mapPattern;
            PatternMapper._setMap(mapper, key.method_29177(), "", HexDir.EAST);
        }
    }

    static {
        mapPatternMeta.put("\\", IotaFactory.makePattern("qqqaw", HexDir.WEST));
        mapPatternMeta.put("del", IotaFactory.makePattern("eeedw", HexDir.EAST));
        mapPatternMeta.put("(", IotaFactory.makePattern("qqq", HexDir.WEST));
        mapPatternMeta.put(")", IotaFactory.makePattern("eee", HexDir.EAST));
    }

    public static class ShortNameTracker {
        public static final Map<String, class_2487>[] modifyTargets = new Map[]{mapPattern, mapPatternWorld};
        public static final Map<String, Set<class_2960>> allPointed = new HashMap<String, Set<class_2960>>();
        public static final Map<String, class_2960> mapActiveShortName = new HashMap<String, class_2960>();
        public static final Set<String> shortNameWithConflicts = new HashSet<String>();
        private static ShortNameTrackerPersistent manualTargets;

        static boolean recordNewShortName(class_2960 id) {
            boolean imBoss;
            String shortName = id.method_12832();
            String longName = id.toString();
            Set locList = allPointed.computeIfAbsent(shortName, k -> new HashSet());
            locList.add(id);
            if (locList.size() > 1) {
                shortNameWithConflicts.add(shortName);
            }
            class_2960 idExist = mapActiveShortName.get(shortName);
            boolean manualSelected = false;
            boolean manualOld = false;
            if (manualTargets != null) {
                String selectedLong = manualTargets.get(shortName);
                manualSelected = longName.equals(selectedLong);
                manualOld = !class_3544.method_15438((String)selectedLong);
            }
            boolean bl = imBoss = manualSelected || !manualOld && id.method_12836().equals("hexcasting");
            if (idExist == null || imBoss) {
                mapActiveShortName.put(shortName, id);
                return true;
            }
            return false;
        }

        static void clear(class_3218 level) {
            allPointed.clear();
            mapActiveShortName.clear();
            shortNameWithConflicts.clear();
            manualTargets = ShortNameTrackerPersistent.get(level);
        }

        public static String getActiveLongName(String shortName) {
            class_2960 id = mapActiveShortName.get(shortName);
            return id == null ? shortName : id.toString();
        }

        public static void redirectShortName(String shortName, class_2960 newId) {
            Set<class_2960> validIdSet = allPointed.get(shortName);
            if (validIdSet == null || !shortNameWithConflicts.contains(shortName)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.name", new Object[0])));
            }
            if (!validIdSet.contains(newId)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.id", newId)));
            }
            String longName = newId.toString();
            boolean found = false;
            for (Map<String, class_2487> map : modifyTargets) {
                class_2487 tryLongEntry;
                map.remove(shortName);
                if (found || (tryLongEntry = map.get(longName)) == null) continue;
                found = true;
                map.put(shortName, tryLongEntry);
            }
            if (!found) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, "excuse me WTF?"));
            }
            mapActiveShortName.put(shortName, newId);
            if (manualTargets != null) {
                manualTargets.put(shortName, longName);
            }
        }
    }

    private static class ShortNameTrackerPersistent
    extends class_18 {
        static final String SAVENAME = "hexparse.short_name.settings";
        static final class_2487 settings = new class_2487();

        ShortNameTrackerPersistent() {
        }

        ShortNameTrackerPersistent(class_2487 load) {
            settings.method_10543(load);
        }

        static ShortNameTrackerPersistent get(class_3218 level) {
            class_26 ds = level.method_17983();
            return (ShortNameTrackerPersistent)ds.method_17924(ShortNameTrackerPersistent::new, ShortNameTrackerPersistent::new, SAVENAME);
        }

        @NotNull
        public class_2487 method_75(class_2487 body) {
            body.method_10543(settings);
            return body;
        }

        public String get(String shortName) {
            return settings.method_10558(shortName);
        }

        public void put(String shortName, String longName) {
            settings.method_10582(shortName, longName);
        }
    }
}

