/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.macro;

import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.macro.MsgUpdateClientMacro;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MacroManager {
    public static final int MAX_MACRO_COUNT = 1024;
    public static final int MAX_SINGLE_MACRO_SIZE = 1024;
    static final Map<class_3222, class_2487> playerMacros = new HashMap<class_3222, class_2487>();

    public static void receivePlayerMacros(class_3222 player, class_2487 pack) {
        playerMacros.put(player, pack);
    }

    static class_2487 getPool(class_3222 player) {
        return playerMacros.getOrDefault(player, null);
    }

    public static boolean isMacro(String key) {
        return key.startsWith("#");
    }

    public static List<Pair<String, String>> listMacros(class_3222 player, boolean isMacro) {
        class_2487 pool = MacroManager.getPool(player);
        if (pool == null) {
            return List.of();
        }
        ArrayList<Pair<String, String>> res = new ArrayList<Pair<String, String>>();
        for (String k : pool.method_10541()) {
            if (MacroManager.isMacro(k) != isMacro) continue;
            res.add((Pair<String, String>)Pair.of((Object)k, (Object)pool.method_10558(k)));
        }
        return res;
    }

    public static String getMacro(class_3222 player, String key) {
        class_2487 pool = MacroManager.getPool(player);
        if (pool == null) {
            return null;
        }
        if (!pool.method_10573(key, 8)) {
            return null;
        }
        return pool.method_10558(key);
    }

    public static boolean willThisExceedLimit(class_3222 player, String key) {
        class_2487 pool = MacroManager.getPool(player);
        if (pool == null) {
            return false;
        }
        if (pool.method_10545(key)) {
            return false;
        }
        return pool.method_10546() >= 1024;
    }

    public static void modifyMacro(class_3222 player, boolean isDefine, String key, String value) {
        class_2487 pool = MacroManager.getPool(player);
        if (pool == null) {
            return;
        }
        if (isDefine) {
            pool.method_10582(key, value);
        } else {
            pool.method_10551(key);
        }
        MsgHandlers.SERVER.sendPacketToPlayer(player, new MsgUpdateClientMacro(isDefine, key, value));
        if (isDefine) {
            player.method_43496((class_2561)class_2561.method_43469((String)"hexparse.cmd.macro.define", (Object[])new Object[]{MacroManager.showGold(key), MacroManager.showGold(value)}));
        } else {
            player.method_43496((class_2561)class_2561.method_43469((String)"hexparse.cmd.macro.remove", (Object[])new Object[]{MacroManager.showGold(key)}));
        }
    }

    public static class_5250 showGold(String val) {
        return CodeHelpers.wrapClickCopy(class_2561.method_43470((String)val).method_27692(class_124.field_1065), val);
    }
}

