/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.misc;

import java.util.ArrayList;
import java.util.Collections;

public class NumEvaluatorBrute {
    static double TOLERANCE = 1.0E-5;
    static double MAX_VALUE = 9.223372036854776E18;
    static int MAX_DECIMAL_REACH = 100;

    public static String getAnglesFromNum(double target) {
        return NumEvaluatorBrute.getAnglesFromNum(target, TOLERANCE);
    }

    public static String getAnglesFromNum(Double target, double tolerance) {
        if (target.isNaN()) {
            target = 0.0;
        }
        boolean neg = target < 0.0;
        target = Math.min(Math.abs(target), MAX_VALUE);
        ArrayList<String> seqList = new ArrayList<String>();
        for (int i = 0; i < MAX_DECIMAL_REACH && !(target % 1.0 < tolerance); tolerance *= 2.0, ++i) {
            target = target * 2.0;
            seqList.add("d");
        }
        long n = Math.round(target);
        while (n != 0L) {
            if ((n & 0xAL) == 10L) {
                seqList.add("e");
                n ^= 0xAL;
                continue;
            }
            if ((n & 5L) == 5L) {
                seqList.add("q");
                n ^= 5L;
                continue;
            }
            if ((n & 1L) == 1L) {
                seqList.add("w");
                n ^= 1L;
                continue;
            }
            seqList.add("a");
            n >>>= 1;
        }
        seqList.add(neg ? "dedd" : "aqaa");
        Collections.reverse(seqList);
        return String.join((CharSequence)"", seqList);
    }
}

