/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.config.HexParseConfig;
import io.yukkuric.hexparse.macro.MacroClient;
import io.yukkuric.hexparse.macro.MacroProcessor;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.parsers.CodeCutter;
import io.yukkuric.hexparse.parsers.CostTracker;
import io.yukkuric.hexparse.parsers.FallbackBinaryParser;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.IotaFactory;
import io.yukkuric.hexparse.parsers.nbt2str.BoolParser;
import io.yukkuric.hexparse.parsers.nbt2str.CommentParser;
import io.yukkuric.hexparse.parsers.nbt2str.EntityParser;
import io.yukkuric.hexparse.parsers.nbt2str.GarbageParser;
import io.yukkuric.hexparse.parsers.nbt2str.INbt2Str;
import io.yukkuric.hexparse.parsers.nbt2str.NullParser;
import io.yukkuric.hexparse.parsers.nbt2str.NumParser;
import io.yukkuric.hexparse.parsers.nbt2str.PatternParser;
import io.yukkuric.hexparse.parsers.nbt2str.VecParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.GateParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.IdentifierParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.ItemTypeParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.MatrixParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.PropertyParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.StringLitParser;
import io.yukkuric.hexparse.parsers.nbt2str.plugins.StringParser;
import io.yukkuric.hexparse.parsers.str2nbt.ConstParsers;
import io.yukkuric.hexparse.parsers.str2nbt.IStr2Nbt;
import io.yukkuric.hexparse.parsers.str2nbt.ToDialect;
import io.yukkuric.hexparse.parsers.str2nbt.ToEntity;
import io.yukkuric.hexparse.parsers.str2nbt.ToMiscConst;
import io.yukkuric.hexparse.parsers.str2nbt.ToPattern;
import io.yukkuric.hexparse.parsers.str2nbt.plugins.PluginConstParsers;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;

public class ParserMain {
    static boolean mutableFlag = false;
    static List<IStr2Nbt> str2nbtParsers = new ArrayList<IStr2Nbt>();
    static List<INbt2Str> nbt2strParsers = new ArrayList<INbt2Str>();
    static class_2487 IGNORED = new class_2487();

    public static class_2487 ParseSingleNode(String frag) {
        for (IStr2Nbt p : str2nbtParsers) {
            if (!p.match(frag)) continue;
            if (p.ignored()) {
                return IGNORED;
            }
            class_2487 res = p.parse(frag);
            CostTracker.INSTANCE.addCost(p.getCost());
            return res;
        }
        return null;
    }

    public static synchronized class_2487 ParseCode(String code, class_3222 caller) {
        try {
            return ParserMain.ParseCode(CodeCutter.splitCode(code), caller);
        }
        catch (Throwable e) {
            caller.method_43496(CodeHelpers.dumpError(class_2561.method_43469((String)"hexparse.msg.parse_error", (Object[])new Object[]{e.getLocalizedMessage()}), e));
            return IotaFactory.makeList(new class_2499());
        }
    }

    public static synchronized class_2487 ParseCode(List<String> nodes, class_3222 caller) {
        if (caller == null) {
            return IotaFactory.makeList(new class_2499());
        }
        CodeHelpers.autoRefresh(caller.method_5682());
        for (IStr2Nbt p : str2nbtParsers) {
            if (!(p instanceof IPlayerBinder)) continue;
            IPlayerBinder pb = (IPlayerBinder)((Object)p);
            pb.BindPlayer(caller);
        }
        try (CostTracker ignored = CostTracker.INSTANCE.beginTrack(caller);){
            class_2487 class_24872 = ParserMain._parseCode(nodes, caller);
            return class_24872;
        }
    }

    private static class_2487 _parseCode(List<String> nodes, class_3222 caller) {
        Stack<class_2499> stack = new Stack<class_2499>();
        stack.add(new class_2499());
        try {
            MacroProcessor it = new MacroProcessor(nodes.iterator(), caller);
            block12: while (it.hasNext()) {
                String frag;
                switch (frag = it.next()) {
                    case "[": {
                        stack.push(new class_2499());
                        continue block12;
                    }
                    case "]": {
                        if (stack.size() <= 1) {
                            throw new RuntimeException(HexParse.doTranslate("hexparse.msg.error.bracket.closed", new Object[0]));
                        }
                        class_2487 inner = IotaFactory.makeList((class_2499)stack.pop());
                        ((class_2499)stack.peek()).add((Object)inner);
                        continue block12;
                    }
                }
                try {
                    class_2487 parsed = ParserMain.ParseSingleNode(frag);
                    if (parsed == null) {
                        caller.method_43496((class_2561)class_2561.method_43469((String)"hexparse.msg.error.unknown_symbol", (Object[])new Object[]{frag}).method_27692(class_124.field_1065));
                        continue;
                    }
                    if (parsed == IGNORED) continue;
                    ((class_2499)stack.peek()).add((Object)parsed);
                }
                catch (Throwable e) {
                    caller.method_43496(CodeHelpers.dumpError(class_2561.method_43469((String)"hexparse.msg.parse_error_node", (Object[])new Object[]{frag, e.getLocalizedMessage()}), e));
                }
            }
            if (stack.size() > 1) {
                throw new RuntimeException(HexParse.doTranslate("hexparse.msg.error.bracket.open", new Object[0]));
            }
        }
        catch (Throwable e) {
            caller.method_43496(CodeHelpers.dumpError(class_2561.method_43469((String)"hexparse.msg.parse_error", (Object[])new Object[]{e.getLocalizedMessage()}), e));
            while (stack.size() > 1) {
                class_2487 sub = IotaFactory.makeList((class_2499)stack.pop());
                ((class_2499)stack.peek()).add((Object)sub);
            }
            return IotaFactory.makeList(stack.isEmpty() ? new class_2499() : (class_2499)stack.pop());
        }
        return IotaFactory.makeList((class_2499)stack.pop());
    }

    public static List<String> preMatchClipboardClient(String code) {
        List<String> frags;
        ArrayList<String> res = new ArrayList<String>();
        class_746 caller = class_310.method_1551().field_1724;
        try {
            frags = CodeCutter.splitCode(code);
        }
        catch (Throwable e) {
            if (caller != null) {
                caller.method_43496(CodeHelpers.dumpError(class_2561.method_43469((String)"hexparse.msg.parse_error", (Object[])new Object[]{e.getLocalizedMessage()}), e));
            }
            return res;
        }
        for (String frag : frags) {
            boolean matched = false;
            if ("[]".contains(frag) || MacroClient.preMatch(frag)) {
                res.add(frag);
                matched = true;
            } else {
                for (IStr2Nbt p : str2nbtParsers) {
                    if (!p.match(frag) || p.ignored()) continue;
                    res.add(frag);
                    matched = true;
                    break;
                }
            }
            if (matched || caller == null) continue;
            caller.method_43496((class_2561)class_2561.method_43469((String)"hexparse.msg.error.unknown_symbol", (Object[])new Object[]{frag}).method_27692(class_124.field_1065));
        }
        return res;
    }

    public static synchronized String ParseIotaNbt(class_2487 node, class_3222 caller, StringProcessors.F post) {
        String res = ParserMain._parseIotaNbt(node, caller, true);
        res = (String)post.apply(res);
        return res;
    }

    private static synchronized String _parseIotaNbt(class_2487 node, class_3222 caller, boolean isRoot) {
        if (isRoot) {
            for (INbt2Str p : nbt2strParsers) {
                if (!(p instanceof IPlayerBinder)) continue;
                IPlayerBinder pb = (IPlayerBinder)((Object)p);
                pb.BindPlayer(caller);
            }
        }
        try {
            if (node.method_10558("hexcasting:type").equals("hexcasting:list")) {
                StringBuilder sb = new StringBuilder();
                if (!isRoot) {
                    sb.append('[');
                }
                boolean isFirst = true;
                for (class_2520 sub : node.method_10554("hexcasting:data", 10)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(ParserMain._parseIotaNbt((class_2487)sub, caller, false));
                }
                if (!isRoot) {
                    sb.append(']');
                }
                return sb.toString();
            }
            for (INbt2Str p : nbt2strParsers) {
                if (!p.match(node)) continue;
                return p.parse(node);
            }
            return switch (HexParseConfig.showUnknownNBT()) {
                case HexParseConfig.UnknownNbtHandlingMode.KEEP_NBT -> FallbackBinaryParser.NBT2STR.INSTANCE.parse(node);
                case HexParseConfig.UnknownNbtHandlingMode.SHOW_NBT -> "UNKNOWN(%s)".formatted(node.toString());
                default -> "UNKNOWN";
            };
        }
        catch (Throwable e) {
            caller.method_43496(CodeHelpers.dumpError(class_2561.method_43469((String)"hexparse.msg.parse_error_node", (Object[])new Object[]{node, e.getLocalizedMessage()}), e));
            return "ERROR";
        }
    }

    public static <T> T loadUnsafe(Class<T> target, String subPath) {
        try {
            Class<?> clazz = Class.forName("io.yukkuric.hexparse.parsers." + subPath);
            Object inst = clazz.getDeclaredField("INSTANCE").get(null);
            return target.cast(inst);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void init() {
        str2nbtParsers.addAll(List.of(ToPattern.META, ToMiscConst.INSTANCE, FallbackBinaryParser.STR2NBT.INSTANCE, ToPattern.NORMAL, ToPattern.GREAT, ConstParsers.TO_TAB, ConstParsers.TO_COMMENT, ConstParsers.TO_SCOMMENT, ConstParsers.TO_NUM, ConstParsers.TO_VEC, ConstParsers.TO_MASK, ConstParsers.TO_NUM_PATTERN, new ToEntity(), ToDialect.INSTANCE, ConstParsers.TO_RAW_PATTERN));
        nbt2strParsers.addAll(List.of(new PatternParser(), new CommentParser(), new NumParser(), new VecParser(), new EntityParser(), new BoolParser(), new NullParser(), new GarbageParser()));
        if (HexParse.HELPERS.modLoaded("hexal")) {
            str2nbtParsers.add(ParserMain.loadUnsafe(IStr2Nbt.class, "str2nbt.unsafe.hexal.ToGate"));
            nbt2strParsers.add(new GateParser());
            str2nbtParsers.add(ParserMain.loadUnsafe(IStr2Nbt.class, "str2nbt.unsafe.hexal.ToMote"));
            nbt2strParsers.add(ParserMain.loadUnsafe(INbt2Str.class, "nbt2str.unsafe.hexal.MoteParser"));
        }
        if (HexParse.HELPERS.modLoaded("moreiotas")) {
            str2nbtParsers.add(PluginConstParsers.TO_ENTITY_TYPE);
            str2nbtParsers.add(PluginConstParsers.TO_IOTA_TYPE);
            str2nbtParsers.add(PluginConstParsers.TO_ITEM_TYPE);
            str2nbtParsers.add(PluginConstParsers.TO_BLOCK_TYPE);
            nbt2strParsers.add(StringParser.IOTA);
            nbt2strParsers.add(StringParser.ENTITY);
            nbt2strParsers.add(new ItemTypeParser());
            str2nbtParsers.add(PluginConstParsers.TO_STRING);
            str2nbtParsers.add(PluginConstParsers.TO_STRING_LIT);
            nbt2strParsers.add(new StringLitParser());
            str2nbtParsers.add(PluginConstParsers.TO_MATRIX);
            nbt2strParsers.add(MatrixParser.INSTANCE);
        }
        if (HexParse.HELPERS.modLoaded("hexcellular")) {
            str2nbtParsers.add(PluginConstParsers.TO_PROPERTY);
            str2nbtParsers.add(PluginConstParsers.TO_MY_PROPERTY);
            nbt2strParsers.add(PropertyParser.INSTANCE);
        }
        if (HexParse.HELPERS.modLoaded("hexpose")) {
            str2nbtParsers.add(PluginConstParsers.TO_IDENTIFIER);
            nbt2strParsers.add(IdentifierParser.INSTANCE);
        }
    }

    public static void AddForthParser(IStr2Nbt p) {
        str2nbtParsers.add(p);
    }

    public static void AddBackParser(INbt2Str p) {
        nbt2strParsers.add(p);
    }
}

